/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.springframework.integration.file.filters.DiscardAwareFileListFilter;
import org.springframework.lang.Nullable;

public class LastModifiedFileListFilter
implements DiscardAwareFileListFilter<File> {
    private static final long ONE_SECOND = 1000L;
    private static final long DEFAULT_AGE = 60L;
    private volatile long age = 60L;
    @Nullable
    private Consumer<File> discardCallback;

    public LastModifiedFileListFilter() {
    }

    public LastModifiedFileListFilter(long age) {
        this.age = age;
    }

    public void setAge(long age, TimeUnit unit) {
        this.age = unit.toSeconds(age);
    }

    public void setAge(Duration age) {
        this.setAge(age.getSeconds());
    }

    public void setAge(long age) {
        this.setAge(age, TimeUnit.SECONDS);
    }

    public long getAge() {
        return this.age;
    }

    @Override
    public void addDiscardCallback(@Nullable Consumer<File> discardCallback) {
        this.discardCallback = discardCallback;
    }

    public List<File> filterFiles(File[] files) {
        ArrayList<File> list = new ArrayList<File>();
        long now = System.currentTimeMillis() / 1000L;
        for (File file : files) {
            if (file.lastModified() / 1000L + this.age <= now) {
                list.add(file);
                continue;
            }
            if (this.discardCallback == null) continue;
            this.discardCallback.accept(file);
        }
        return list;
    }
}

