/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.springframework.integration.file.remote.session.Session;

public final class RemoteFileUtils {
    private RemoteFileUtils() {
    }

    public static synchronized <F> void makeDirectories(String path, Session<F> session, String remoteFileSeparator, Log logger) throws IOException {
        if (!session.exists(path)) {
            int nextSeparatorIndex = path.lastIndexOf(remoteFileSeparator);
            if (nextSeparatorIndex > -1) {
                String pathSegment;
                LinkedList<String> pathsToCreate = new LinkedList<String>();
                while (nextSeparatorIndex > -1 && (pathSegment = path.substring(0, nextSeparatorIndex)).length() != 0 && !session.exists(pathSegment)) {
                    pathsToCreate.add(0, pathSegment);
                    nextSeparatorIndex = pathSegment.lastIndexOf(remoteFileSeparator);
                }
                for (String pathToCreate : pathsToCreate) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Creating '" + pathToCreate + "'"));
                    }
                    session.mkdir(pathToCreate);
                }
            } else {
                session.mkdir(path);
            }
        }
    }
}

