/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.dsl;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.ExpressionFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.RegexPatternFileListFilter;
import org.springframework.integration.file.filters.SimplePatternFileListFilter;
import org.springframework.integration.file.remote.gateway.AbstractRemoteFileOutboundGateway;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.messaging.Message;

public abstract class RemoteFileOutboundGatewaySpec<F, S extends RemoteFileOutboundGatewaySpec<F, S>>
extends MessageHandlerSpec<S, AbstractRemoteFileOutboundGateway<F>>
implements ComponentsRegistration {
    private CompositeFileListFilter<F> filter;
    private ExpressionFileListFilter<F> expressionFileListFilter;
    private ExpressionFileListFilter<File> mputExpressionFileListFilter;
    private CompositeFileListFilter<File> mputFilter;

    protected RemoteFileOutboundGatewaySpec(AbstractRemoteFileOutboundGateway<F> outboundGateway) {
        this.target = outboundGateway;
        ((AbstractRemoteFileOutboundGateway)((Object)this.target)).setRequiresReply(true);
    }

    public S options(String options) {
        ((AbstractRemoteFileOutboundGateway)((Object)this.target)).setOptions(options);
        return (S)((Object)((RemoteFileOutboundGatewaySpec)this._this()));
    }

    public S options(AbstractRemoteFileOutboundGateway.Option ... options) {
        ((AbstractRemoteFileOutboundGateway)((Object)this.target)).setOption(options);
        return (S)((Object)((RemoteFileOutboundGatewaySpec)this._this()));
    }

    public S remoteFileSeparator(String remoteFileSeparator) {
        ((AbstractRemoteFileOutboundGateway)((Object)this.target)).setRemoteFileSeparator(remoteFileSeparator);
        return (S)((Object)((RemoteFileOutboundGatewaySpec)this._this()));
    }

    public S localDirectory(File localDirectory) {
        ((AbstractRemoteFileOutboundGateway)((Object)this.target)).setLocalDirectory(localDirectory);
        return (S)((Object)((RemoteFileOutboundGatewaySpec)this._this()));
    }

    public S localDirectoryExpression(String localDirectoryExpression) {
        return this.localDirectoryExpression(PARSER.parseExpression(localDirectoryExpression));
    }

    public <P> S localDirectory(Function<Message<P>, String> localDirectoryFunction) {
        return this.localDirectoryExpression((Expression)new FunctionExpression(localDirectoryFunction));
    }

    public S localDirectoryExpression(Expression localDirectoryExpression) {
        ((AbstractRemoteFileOutboundGateway)((Object)this.target)).setLocalDirectoryExpression(localDirectoryExpression);
        return (S)((Object)((RemoteFileOutboundGatewaySpec)this._this()));
    }

    public S autoCreateLocalDirectory(boolean autoCreateLocalDirectory) {
        ((AbstractRemoteFileOutboundGateway)((Object)this.target)).setAutoCreateLocalDirectory(autoCreateLocalDirectory);
        return (S)((Object)((RemoteFileOutboundGatewaySpec)this._this()));
    }

    public S temporaryFileSuffix(String temporaryFileSuffix) {
        ((AbstractRemoteFileOutboundGateway)((Object)this.target)).setTemporaryFileSuffix(temporaryFileSuffix);
        return (S)((Object)((RemoteFileOutboundGatewaySpec)this._this()));
    }

    public S filter(FileListFilter<F> filter) {
        if (this.filter == null) {
            if (filter instanceof CompositeFileListFilter) {
                this.filter = (CompositeFileListFilter)filter;
            } else {
                this.filter = new CompositeFileListFilter();
                this.filter.addFilter(filter);
            }
            ((AbstractRemoteFileOutboundGateway)((Object)this.target)).setFilter(this.filter);
        } else {
            this.filter.addFilter(filter);
        }
        return (S)((Object)((RemoteFileOutboundGatewaySpec)this._this()));
    }

    public S filterExpression(String expression) {
        this.expressionFileListFilter = new ExpressionFileListFilter(expression);
        return this.filter(this.expressionFileListFilter);
    }

    public S filterFunction(Function<F, Boolean> filterFunction) {
        this.expressionFileListFilter = new ExpressionFileListFilter((Expression)new FunctionExpression(filterFunction));
        return this.filter(this.expressionFileListFilter);
    }

    public S mputFilter(FileListFilter<File> filter) {
        if (this.mputFilter == null) {
            if (filter instanceof CompositeFileListFilter) {
                this.mputFilter = (CompositeFileListFilter)filter;
            } else {
                this.mputFilter = new CompositeFileListFilter();
                this.mputFilter.addFilter(filter);
            }
            ((AbstractRemoteFileOutboundGateway)((Object)this.target)).setMputFilter(this.mputFilter);
        } else {
            this.mputFilter.addFilter(filter);
        }
        return (S)((Object)((RemoteFileOutboundGatewaySpec)this._this()));
    }

    public S patternMputFilter(String pattern) {
        return this.mputFilter(new SimplePatternFileListFilter(pattern));
    }

    public S regexMputFilter(String regex) {
        return this.mputFilter(new RegexPatternFileListFilter(regex));
    }

    public S mputFilterExpression(String expression) {
        this.mputExpressionFileListFilter = new ExpressionFileListFilter(expression);
        return this.mputFilter(this.mputExpressionFileListFilter);
    }

    public S mputFilterFunction(Function<File, Boolean> filterFunction) {
        this.mputExpressionFileListFilter = new ExpressionFileListFilter((Expression)new FunctionExpression(filterFunction));
        return this.mputFilter(this.mputExpressionFileListFilter);
    }

    public S renameExpression(String expression) {
        ((AbstractRemoteFileOutboundGateway)((Object)this.target)).setRenameExpressionString(expression);
        return (S)((Object)((RemoteFileOutboundGatewaySpec)this._this()));
    }

    public S renameExpression(Expression expression) {
        ((AbstractRemoteFileOutboundGateway)((Object)this.target)).setRenameExpression(expression);
        return (S)((Object)((RemoteFileOutboundGatewaySpec)this._this()));
    }

    public <P> S renameFunction(Function<Message<P>, String> renameFunction) {
        ((AbstractRemoteFileOutboundGateway)((Object)this.target)).setRenameExpression((Expression)new FunctionExpression(renameFunction));
        return (S)((Object)((RemoteFileOutboundGatewaySpec)this._this()));
    }

    public S localFilenameExpression(String localFilenameExpression) {
        return this.localFilenameExpression(PARSER.parseExpression(localFilenameExpression));
    }

    public <P> S localFilename(Function<Message<P>, String> localFilenameFunction) {
        return this.localFilenameExpression((Expression)new FunctionExpression(localFilenameFunction));
    }

    public S localFilenameExpression(Expression localFilenameExpression) {
        ((AbstractRemoteFileOutboundGateway)((Object)this.target)).setLocalFilenameGeneratorExpression(localFilenameExpression);
        return (S)((Object)((RemoteFileOutboundGatewaySpec)this._this()));
    }

    public S chmod(int chmod) {
        ((AbstractRemoteFileOutboundGateway)((Object)this.target)).setChmod(chmod);
        return (S)((Object)((RemoteFileOutboundGatewaySpec)this._this()));
    }

    public S fileExistsMode(FileExistsMode fileExistsMode) {
        ((AbstractRemoteFileOutboundGateway)((Object)this.target)).setFileExistsMode(fileExistsMode);
        return (S)((Object)((RemoteFileOutboundGatewaySpec)this._this()));
    }

    public Map<Object, String> getComponentsToRegister() {
        LinkedHashMap<Object, String> componentsToRegister = new LinkedHashMap<Object, String>();
        if (this.expressionFileListFilter != null) {
            componentsToRegister.put(this.expressionFileListFilter, null);
        }
        if (this.mputExpressionFileListFilter != null) {
            componentsToRegister.put(this.mputExpressionFileListFilter, null);
        }
        return componentsToRegister;
    }

    public abstract S patternFileNameFilter(String var1);

    public abstract S regexFileNameFilter(String var1);
}

