/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.support;

import java.lang.reflect.Array;
import java.nio.file.FileSystems;
import java.util.Arrays;
import java.util.function.Predicate;
import org.springframework.util.ObjectUtils;

public final class FileUtils {
    public static final boolean IS_POSIX = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");

    public static <F> F[] purgeUnwantedElements(F[] fileArray, Predicate<F> predicate) {
        if (ObjectUtils.isEmpty((Object[])fileArray)) {
            return fileArray;
        }
        return Arrays.stream(fileArray).filter(predicate.negate()).toArray(size -> (Object[])Array.newInstance(fileArray[0].getClass(), size));
    }

    private FileUtils() {
    }
}

