/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.Expression;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.remote.ClientCallback;
import org.springframework.integration.file.remote.InputStreamCallback;
import org.springframework.integration.file.remote.OperationsCallback;
import org.springframework.integration.file.remote.RemoteFileOperations;
import org.springframework.integration.file.remote.RemoteFileUtils;
import org.springframework.integration.file.remote.SessionCallback;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RemoteFileTemplate<F>
implements RemoteFileOperations<F>,
InitializingBean,
BeanFactoryAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    protected final SessionFactory<F> sessionFactory;
    private final ThreadLocal<Session<F>> contextSessions = new ThreadLocal();
    private final AtomicInteger activeTemplateCallbacks = new AtomicInteger();
    private volatile String temporaryFileSuffix = ".writing";
    private volatile boolean autoCreateDirectory = false;
    private volatile boolean useTemporaryFileName = true;
    private volatile ExpressionEvaluatingMessageProcessor<String> directoryExpressionProcessor;
    private volatile ExpressionEvaluatingMessageProcessor<String> temporaryDirectoryExpressionProcessor;
    private volatile ExpressionEvaluatingMessageProcessor<String> fileNameProcessor;
    private volatile FileNameGenerator fileNameGenerator = new DefaultFileNameGenerator();
    private volatile boolean fileNameGeneratorSet;
    private volatile String charset = "UTF-8";
    private volatile String remoteFileSeparator = "/";
    private volatile boolean hasExplicitlySetSuffix;
    private volatile BeanFactory beanFactory;

    public RemoteFileTemplate(SessionFactory<F> sessionFactory) {
        Assert.notNull(sessionFactory, (String)"sessionFactory must not be null");
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory<F> getSessionFactory() {
        return this.sessionFactory;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        Assert.notNull((Object)remoteFileSeparator, (String)"'remoteFileSeparator' must not be null");
        this.remoteFileSeparator = remoteFileSeparator;
    }

    public final String getRemoteFileSeparator() {
        return this.remoteFileSeparator;
    }

    public void setRemoteDirectoryExpression(Expression remoteDirectoryExpression) {
        Assert.notNull((Object)remoteDirectoryExpression, (String)"remoteDirectoryExpression must not be null");
        this.directoryExpressionProcessor = new ExpressionEvaluatingMessageProcessor(remoteDirectoryExpression, String.class);
    }

    public void setTemporaryRemoteDirectoryExpression(Expression temporaryRemoteDirectoryExpression) {
        Assert.notNull((Object)temporaryRemoteDirectoryExpression, (String)"temporaryRemoteDirectoryExpression must not be null");
        this.temporaryDirectoryExpressionProcessor = new ExpressionEvaluatingMessageProcessor(temporaryRemoteDirectoryExpression, String.class);
    }

    public void setFileNameExpression(Expression fileNameExpression) {
        Assert.notNull((Object)fileNameExpression, (String)"fileNameExpression must not be null");
        this.fileNameProcessor = new ExpressionEvaluatingMessageProcessor(fileNameExpression, String.class);
    }

    public String getTemporaryFileSuffix() {
        return this.temporaryFileSuffix;
    }

    public boolean isUseTemporaryFileName() {
        return this.useTemporaryFileName;
    }

    public void setUseTemporaryFileName(boolean useTemporaryFileName) {
        this.useTemporaryFileName = useTemporaryFileName;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.fileNameGenerator = fileNameGenerator != null ? fileNameGenerator : new DefaultFileNameGenerator();
        this.fileNameGeneratorSet = fileNameGenerator != null;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        Assert.notNull((Object)temporaryFileSuffix, (String)"'temporaryFileSuffix' must not be null");
        this.hasExplicitlySetSuffix = true;
        this.temporaryFileSuffix = temporaryFileSuffix;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory != null) {
            if (this.directoryExpressionProcessor != null) {
                this.directoryExpressionProcessor.setBeanFactory(beanFactory);
            }
            if (this.temporaryDirectoryExpressionProcessor != null) {
                this.temporaryDirectoryExpressionProcessor.setBeanFactory(beanFactory);
            }
            if (!this.fileNameGeneratorSet && this.fileNameGenerator instanceof BeanFactoryAware) {
                ((BeanFactoryAware)this.fileNameGenerator).setBeanFactory(beanFactory);
            }
            if (this.fileNameProcessor != null) {
                this.fileNameProcessor.setBeanFactory(beanFactory);
            }
        }
        if (this.autoCreateDirectory) {
            Assert.hasText((String)this.remoteFileSeparator, (String)"'remoteFileSeparator' must not be empty when 'autoCreateDirectory' is set to 'true'");
        }
        if (this.hasExplicitlySetSuffix && !this.useTemporaryFileName) {
            this.logger.warn((Object)"Since 'use-temporary-file-name' is set to 'false' the value of 'temporary-file-suffix' has no effect");
        }
    }

    @Override
    public String append(Message<?> message) {
        return this.append(message, null);
    }

    @Override
    public String append(Message<?> message, String subDirectory) {
        return this.send(message, subDirectory, FileExistsMode.APPEND);
    }

    @Override
    public String send(Message<?> message, FileExistsMode ... mode) {
        return this.send(message, (String)null, mode);
    }

    @Override
    public String send(Message<?> message, String subDirectory, FileExistsMode ... mode) {
        FileExistsMode modeToUse = mode == null || mode.length < 1 || mode[0] == null ? FileExistsMode.REPLACE : mode[0];
        return this.send(message, subDirectory, modeToUse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String send(Message<?> message, String subDirectory, FileExistsMode mode) {
        Assert.notNull(this.directoryExpressionProcessor, (String)"'remoteDirectoryExpression' is required");
        Assert.isTrue((!FileExistsMode.APPEND.equals((Object)mode) || !this.useTemporaryFileName ? 1 : 0) != 0, (String)"Cannot append when using a temporary file name");
        Assert.isTrue((!FileExistsMode.REPLACE_IF_MODIFIED.equals((Object)mode) ? 1 : 0) != 0, (String)"FilExistsMode.REPLACE_IF_MODIFIED can only be used for local files");
        StreamHolder inputStreamHolder = this.payloadToInputStream(message);
        if (inputStreamHolder != null) {
            try {
                String string = this.execute(session -> {
                    String fileName = inputStreamHolder.getName();
                    try {
                        String remoteDirectory = (String)this.directoryExpressionProcessor.processMessage(message);
                        remoteDirectory = this.normalizeDirectoryPath(remoteDirectory);
                        if (StringUtils.hasText((String)subDirectory)) {
                            remoteDirectory = subDirectory.startsWith(this.remoteFileSeparator) ? remoteDirectory + subDirectory.substring(1) : remoteDirectory + this.normalizeDirectoryPath(subDirectory);
                        }
                        String temporaryRemoteDirectory = remoteDirectory;
                        if (this.temporaryDirectoryExpressionProcessor != null) {
                            temporaryRemoteDirectory = (String)this.temporaryDirectoryExpressionProcessor.processMessage(message);
                        }
                        fileName = this.fileNameGenerator.generateFileName(message);
                        this.sendFileToRemoteDirectory(inputStreamHolder.getStream(), temporaryRemoteDirectory, remoteDirectory, fileName, session, mode);
                        return remoteDirectory + fileName;
                    }
                    catch (FileNotFoundException e) {
                        throw new MessageDeliveryException(message, "File [" + inputStreamHolder.getName() + "] not found in local working directory; it was moved or deleted unexpectedly.", (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new MessageDeliveryException(message, "Failed to transfer file [" + inputStreamHolder.getName() + " -> " + fileName + "] from local directory to remote directory.", (Throwable)e);
                    }
                    catch (Exception e) {
                        throw new MessageDeliveryException(message, "Error handling message for file [" + inputStreamHolder.getName() + " -> " + fileName + "]", (Throwable)e);
                    }
                });
                return string;
            }
            finally {
                try {
                    inputStreamHolder.getStream().close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("File " + message.getPayload() + " does not exist"));
        }
        return null;
    }

    @Override
    public boolean exists(String path) {
        return this.execute(session -> session.exists(path));
    }

    @Override
    public boolean remove(String path) {
        return this.execute(session -> session.remove(path));
    }

    @Override
    public void rename(String fromPath, String toPath) {
        Assert.hasText((String)fromPath, (String)"Old filename cannot be null or empty");
        Assert.hasText((String)toPath, (String)"New filename cannot be null or empty");
        this.execute(session -> {
            int lastSeparator = toPath.lastIndexOf(this.remoteFileSeparator);
            if (lastSeparator > 0) {
                String remoteFileDirectory = toPath.substring(0, lastSeparator + 1);
                RemoteFileUtils.makeDirectories(remoteFileDirectory, session, this.remoteFileSeparator, this.logger);
            }
            session.rename(fromPath, toPath);
        });
    }

    @Override
    public boolean get(Message<?> message, InputStreamCallback callback) {
        Assert.notNull(this.fileNameProcessor, (String)"A 'fileNameExpression' is needed to use get");
        String remotePath = (String)this.fileNameProcessor.processMessage(message);
        return this.get(remotePath, callback);
    }

    @Override
    public boolean get(String remotePath, InputStreamCallback callback) {
        Assert.notNull((Object)remotePath, (String)"'remotePath' cannot be null");
        return this.execute(session -> {
            try (InputStream inputStream = null;){
                inputStream = session.readRaw(remotePath);
                callback.doWithInputStream(inputStream);
                Boolean bl = session.finalizeRaw();
                return bl;
            }
        });
    }

    @Override
    public F[] list(String path) {
        return this.execute(session -> session.list(path));
    }

    @Override
    public Session<F> getSession() {
        Session<F> session;
        if (this.activeTemplateCallbacks.get() > 0 && (session = this.contextSessions.get()) != null) {
            return session;
        }
        return this.sessionFactory.getSession();
    }

    @Override
    public <T> T execute(SessionCallback<F, T> callback) {
        Session<F> session = null;
        boolean invokeScope = false;
        if (this.activeTemplateCallbacks.get() > 0) {
            session = this.contextSessions.get();
        }
        try {
            if (session == null) {
                session = this.sessionFactory.getSession();
            } else {
                invokeScope = true;
            }
            T t = callback.doInSession(session);
            return t;
        }
        catch (Exception e) {
            if (session != null) {
                session.dirty();
            }
            if (e instanceof MessagingException) {
                throw (MessagingException)e;
            }
            throw new MessagingException("Failed to execute on session", (Throwable)e);
        }
        finally {
            block15: {
                if (!invokeScope && session != null) {
                    try {
                        session.close();
                    }
                    catch (Exception ignored) {
                        if (!this.logger.isDebugEnabled()) break block15;
                        this.logger.debug((Object)"failed to close Session", (Throwable)ignored);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invoke(OperationsCallback<F, T> action) {
        Session<F> contextSession = this.contextSessions.get();
        if (contextSession == null) {
            this.contextSessions.set(this.sessionFactory.getSession());
        }
        this.activeTemplateCallbacks.incrementAndGet();
        try {
            T t = action.doInOperations(this);
            return t;
        }
        finally {
            this.activeTemplateCallbacks.decrementAndGet();
            if (contextSession == null) {
                Session<F> session = this.contextSessions.get();
                if (session != null) {
                    session.close();
                }
                this.contextSessions.remove();
            }
        }
    }

    @Override
    public <T, C> T executeWithClient(ClientCallback<C, T> callback) {
        throw new UnsupportedOperationException("executeWithClient() is not supported by the generic template");
    }

    private StreamHolder payloadToInputStream(Message<?> message) throws MessageDeliveryException {
        try {
            Object payload = message.getPayload();
            InputStream dataInputStream = null;
            String name = null;
            if (payload instanceof InputStream) {
                dataInputStream = (InputStream)payload;
            } else if (payload instanceof File) {
                File inputFile = (File)payload;
                if (inputFile.exists()) {
                    dataInputStream = new BufferedInputStream(new FileInputStream(inputFile));
                    name = inputFile.getAbsolutePath();
                }
            } else if (payload instanceof byte[] || payload instanceof String) {
                byte[] bytes = null;
                if (payload instanceof String) {
                    bytes = ((String)payload).getBytes(this.charset);
                    name = "String payload";
                } else {
                    bytes = (byte[])payload;
                    name = "byte[] payload";
                }
                dataInputStream = new ByteArrayInputStream(bytes);
            } else {
                throw new IllegalArgumentException("Unsupported payload type. The only supported payloads are java.io.File, java.lang.String, byte[] and InputStream");
            }
            if (dataInputStream == null) {
                return null;
            }
            return new StreamHolder(dataInputStream, name);
        }
        catch (Exception e) {
            throw new MessageDeliveryException(message, "Failed to create sendable file.", (Throwable)e);
        }
    }

    private void sendFileToRemoteDirectory(InputStream inputStream, String temporaryRemoteDirectory, String remoteDirectory, String fileName, Session<F> session, FileExistsMode mode) throws IOException {
        remoteDirectory = this.normalizeDirectoryPath(remoteDirectory);
        temporaryRemoteDirectory = this.normalizeDirectoryPath(temporaryRemoteDirectory);
        String remoteFilePath = remoteDirectory + fileName;
        String tempRemoteFilePath = temporaryRemoteDirectory + fileName;
        String tempFilePath = tempRemoteFilePath + (this.useTemporaryFileName ? this.temporaryFileSuffix : "");
        if (this.autoCreateDirectory) {
            try {
                RemoteFileUtils.makeDirectories(remoteDirectory, session, this.remoteFileSeparator, this.logger);
            }
            catch (IllegalStateException e) {
                session.mkdir(remoteDirectory);
            }
        }
        try {
            boolean rename = this.useTemporaryFileName;
            if (FileExistsMode.REPLACE.equals((Object)mode)) {
                session.write(inputStream, tempFilePath);
            } else if (FileExistsMode.APPEND.equals((Object)mode)) {
                session.append(inputStream, tempFilePath);
            } else if (this.exists(remoteFilePath)) {
                if (FileExistsMode.FAIL.equals((Object)mode)) {
                    throw new MessagingException("The destination file already exists at '" + remoteFilePath + "'.");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("File not transferred to '" + remoteFilePath + "'; already exists."));
                }
                rename = false;
            } else {
                session.write(inputStream, tempFilePath);
            }
            if (rename) {
                session.rename(tempFilePath, remoteFilePath);
            }
        }
        catch (Exception e) {
            throw new MessagingException("Failed to write to '" + tempFilePath + "' while uploading the file", (Throwable)e);
        }
        finally {
            inputStream.close();
        }
    }

    private String normalizeDirectoryPath(String directoryPath) {
        if (!StringUtils.hasText((String)directoryPath)) {
            directoryPath = "";
        } else if (!directoryPath.endsWith(this.remoteFileSeparator)) {
            directoryPath = directoryPath + this.remoteFileSeparator;
        }
        return directoryPath;
    }

    private static final class StreamHolder {
        private final InputStream stream;
        private final String name;

        private StreamHolder(InputStream stream, String name) {
            this.stream = stream;
            this.name = name;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public String getName() {
            return this.name;
        }
    }
}

