/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.locking;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.integration.MessagingException;
import org.springframework.integration.file.locking.AbstractFileLockerFilter;
import org.springframework.integration.file.locking.FileChannelCache;

public class NioFileLocker
extends AbstractFileLockerFilter {
    private final ConcurrentMap<File, FileLock> lockCache = new ConcurrentHashMap<File, FileLock>();

    @Override
    public boolean lock(File fileToLock) {
        FileLock lock = (FileLock)this.lockCache.get(fileToLock);
        if (lock == null) {
            FileLock newLock = null;
            try {
                newLock = FileChannelCache.tryLockFor(fileToLock);
            }
            catch (IOException e) {
                throw new MessagingException("Failed to lock file: " + fileToLock, (Throwable)e);
            }
            if (newLock != null) {
                FileLock original = this.lockCache.putIfAbsent(fileToLock, newLock);
                lock = original != null ? original : newLock;
            }
        }
        return lock != null;
    }

    @Override
    public boolean isLockable(File file) {
        return this.lockCache.containsKey(file) || !FileChannelCache.isLocked(file);
    }

    @Override
    public void unlock(File fileToUnlock) {
        FileLock fileLock = (FileLock)this.lockCache.get(fileToUnlock);
        try {
            if (fileLock != null) {
                fileLock.release();
            }
            FileChannelCache.closeChannelFor(fileToUnlock);
        }
        catch (IOException e) {
            throw new MessagingException("Failed to unlock file: " + fileToUnlock, (Throwable)e);
        }
    }
}

