/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import java.io.File;
import java.util.regex.Pattern;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.integration.file.AbstractFileListFilter;
import org.springframework.integration.file.AcceptOnceFileListFilter;
import org.springframework.integration.file.CompositeFileListFilter;
import org.springframework.integration.file.FileListFilter;
import org.springframework.integration.file.PatternMatchingFileListFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileListFilterFactoryBean
implements FactoryBean {
    private volatile FileListFilter fileListFilter;
    private volatile FileListFilter filterReference;
    private volatile Pattern filenamePattern;
    private volatile Boolean preventDuplicates;
    private final Object monitor = new Object();

    public void setFilterReference(FileListFilter filterReference) {
        this.filterReference = filterReference;
    }

    public void setFilenamePattern(Pattern filenamePattern) {
        this.filenamePattern = filenamePattern;
    }

    public void setPreventDuplicates(Boolean preventDuplicates) {
        this.preventDuplicates = preventDuplicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() throws Exception {
        if (this.fileListFilter == null) {
            Object object = this.monitor;
            synchronized (object) {
                this.intializeFileListFilter();
            }
        }
        return this.fileListFilter;
    }

    public Class<?> getObjectType() {
        return this.fileListFilter != null ? this.fileListFilter.getClass() : FileListFilter.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private void intializeFileListFilter() {
        if (this.fileListFilter != null) {
            return;
        }
        FileListFilter flf = null;
        if (this.filterReference != null && this.filenamePattern != null) {
            throw new IllegalArgumentException("The 'filter' reference and 'filename-pattern' attributes are mutually exclusive.");
        }
        if (this.filterReference != null) {
            flf = Boolean.TRUE.equals(this.preventDuplicates) ? this.createCompositeWithAcceptOnceFilter(this.filterReference) : this.filterReference;
        } else if (this.filenamePattern != null) {
            PatternMatchingFileListFilter patternFilter = new PatternMatchingFileListFilter(this.filenamePattern);
            flf = Boolean.FALSE.equals(this.preventDuplicates) ? patternFilter : this.createCompositeWithAcceptOnceFilter(patternFilter);
        } else {
            flf = Boolean.FALSE.equals(this.preventDuplicates) ? new AbstractFileListFilter(){

                protected boolean accept(File file) {
                    return true;
                }
            } : new AcceptOnceFileListFilter();
        }
        this.fileListFilter = flf;
    }

    private FileListFilter createCompositeWithAcceptOnceFilter(FileListFilter otherFilter) {
        CompositeFileListFilter compositeFilter = new CompositeFileListFilter(new FileListFilter[0]);
        compositeFilter.addFilter(new AcceptOnceFileListFilter(), otherFilter);
        return compositeFilter;
    }
}

