/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.integration.file.FileListFilter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeFileListFilter
implements FileListFilter {
    private final Set<FileListFilter> fileFilters;

    public CompositeFileListFilter(FileListFilter ... fileFilters) {
        this.fileFilters = new LinkedHashSet<FileListFilter>((Collection)Arrays.asList(fileFilters));
    }

    public CompositeFileListFilter(Collection<FileListFilter> fileFilters) {
        this.fileFilters = new LinkedHashSet<FileListFilter>(fileFilters);
    }

    @Override
    public List<File> filterFiles(File[] files) {
        Assert.notNull((Object)files, (String)"'files' should not be null");
        List<File> leftOver = Arrays.asList(files);
        for (FileListFilter fileFilter : this.fileFilters) {
            leftOver = fileFilter.filterFiles(leftOver.toArray(new File[0]));
        }
        return leftOver;
    }

    public CompositeFileListFilter addFilter(FileListFilter ... filters) {
        return this.addFilters((Collection<FileListFilter>)Arrays.asList(filters));
    }

    public CompositeFileListFilter addFilters(Collection<FileListFilter> filtersToAdd) {
        this.fileFilters.addAll(filtersToAdd);
        return this;
    }
}

