/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.event.inbound;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.integration.endpoint.ExpressionMessageProducerSupport;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class ApplicationEventListeningMessageProducer
extends ExpressionMessageProducerSupport
implements SmartApplicationListener {
    private volatile Set<Class<? extends ApplicationEvent>> eventTypes;
    private ApplicationEventMulticaster applicationEventMulticaster;
    private volatile boolean active;
    private volatile long stoppedAt;

    public void setEventTypes(Class<? extends ApplicationEvent> ... eventTypes) {
        HashSet<Class<? extends ApplicationEvent>> eventSet = new HashSet<Class<? extends ApplicationEvent>>(Arrays.asList(eventTypes));
        eventSet.remove(null);
        Set<Class<Object>> set = this.eventTypes = eventSet.size() > 0 ? eventSet : null;
        if (this.applicationEventMulticaster != null) {
            this.applicationEventMulticaster.addApplicationListener((ApplicationListener)this);
        }
    }

    public String getComponentType() {
        return "event:inbound-channel-adapter";
    }

    protected void onInit() {
        super.onInit();
        this.applicationEventMulticaster = (ApplicationEventMulticaster)this.getBeanFactory().getBean("applicationEventMulticaster", ApplicationEventMulticaster.class);
        Assert.notNull((Object)this.applicationEventMulticaster, (String)"To use ApplicationListeners the 'applicationEventMulticaster' bean must be supplied within ApplicationContext.");
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.active || (event instanceof ContextStoppedEvent || event instanceof ContextClosedEvent) && this.stoppedRecently()) {
            if (event.getSource() instanceof Message) {
                this.sendMessage((Message)event.getSource());
            } else {
                Message message = null;
                Object result = this.evaluatePayloadExpression(event);
                message = result instanceof Message ? (Message)result : this.getMessageBuilderFactory().withPayload(result).build();
                this.sendMessage(message);
            }
        }
    }

    private boolean stoppedRecently() {
        return this.stoppedAt > System.currentTimeMillis() - 5000L;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        if (this.eventTypes == null) {
            return true;
        }
        for (Class<? extends ApplicationEvent> type : this.eventTypes) {
            if (!type.isAssignableFrom(eventType)) continue;
            return true;
        }
        return false;
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    protected void doStart() {
        this.active = true;
    }

    protected void doStop() {
        this.stoppedAt = System.currentTimeMillis();
        this.active = false;
    }
}

