/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.cassandra.dsl;

import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.expression.Expression;
import org.springframework.integration.cassandra.outbound.CassandraMessageHandler;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.messaging.Message;

public class CassandraMessageHandlerSpec
extends MessageHandlerSpec<CassandraMessageHandlerSpec, CassandraMessageHandler> {
    private final Map<String, Expression> parameterExpressions = new HashMap<String, Expression>();

    protected CassandraMessageHandlerSpec(ReactiveCassandraOperations cassandraOperations) {
        this.target = new CassandraMessageHandler(cassandraOperations);
    }

    protected CassandraMessageHandlerSpec(ReactiveCassandraOperations cassandraOperations, CassandraMessageHandler.Type queryType) {
        this.target = new CassandraMessageHandler(cassandraOperations, queryType);
    }

    protected CassandraMessageHandlerSpec producesReply(boolean producesReply) {
        ((CassandraMessageHandler)((Object)this.target)).setProducesReply(producesReply);
        return (CassandraMessageHandlerSpec)this._this();
    }

    public CassandraMessageHandlerSpec ingestQuery(String ingestQuery) {
        ((CassandraMessageHandler)((Object)this.target)).setIngestQuery(ingestQuery);
        return (CassandraMessageHandlerSpec)this._this();
    }

    public CassandraMessageHandlerSpec writeOptions(WriteOptions writeOptions) {
        ((CassandraMessageHandler)((Object)this.target)).setWriteOptions(writeOptions);
        return (CassandraMessageHandlerSpec)this._this();
    }

    public CassandraMessageHandlerSpec statementExpression(String statementExpression) {
        return this.statementExpression(PARSER.parseExpression(statementExpression));
    }

    public CassandraMessageHandlerSpec statementExpression(Expression statementExpression) {
        ((CassandraMessageHandler)((Object)this.target)).setStatementExpression(statementExpression);
        return (CassandraMessageHandlerSpec)this._this();
    }

    public CassandraMessageHandlerSpec statementFunction(Function<Message<?>, Statement<?>> statementFunction) {
        ((CassandraMessageHandler)((Object)this.target)).setStatementProcessor(statementFunction::apply);
        return (CassandraMessageHandlerSpec)this._this();
    }

    public CassandraMessageHandlerSpec query(String query) {
        ((CassandraMessageHandler)((Object)this.target)).setQuery(query);
        return (CassandraMessageHandlerSpec)this._this();
    }

    public CassandraMessageHandlerSpec parameterExpressions(Map<String, Expression> parameterExpressions) {
        ((CassandraMessageHandler)((Object)this.target)).setParameterExpressions(parameterExpressions);
        return (CassandraMessageHandlerSpec)this._this();
    }

    public CassandraMessageHandlerSpec parameter(String name, String expression) {
        return this.parameter(name, PARSER.parseExpression(expression));
    }

    public CassandraMessageHandlerSpec parameter(String name, Function<Message<?>, ?> function) {
        return this.parameter(name, (Expression)new FunctionExpression(function));
    }

    public CassandraMessageHandlerSpec parameter(String name, Expression expression) {
        this.parameterExpressions.put(name, expression);
        return this.parameterExpressions(this.parameterExpressions);
    }
}

