/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.camel.dsl;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.LambdaRouteBuilder;
import org.springframework.expression.Expression;
import org.springframework.integration.camel.outbound.CamelMessageHandler;
import org.springframework.integration.camel.support.CamelHeaderMapper;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CamelMessageHandlerSpec
extends MessageHandlerSpec<CamelMessageHandlerSpec, CamelMessageHandler> {
    private String[] inboundHeaderNames = new String[]{"*"};
    private String[] outboundHeaderNames = new String[]{"*"};

    protected CamelMessageHandlerSpec(@Nullable ProducerTemplate producerTemplate) {
        this.target = producerTemplate == null ? new CamelMessageHandler() : new CamelMessageHandler(producerTemplate);
    }

    public CamelMessageHandlerSpec endpointUri(String endpointUri) {
        ((CamelMessageHandler)((Object)this.target)).setEndpointUri(endpointUri);
        return this;
    }

    public CamelMessageHandlerSpec endpointUri(Function<org.springframework.messaging.Message<?>, String> endpointUriFunction) {
        return this.endpointUriExpression((Expression)new FunctionExpression(endpointUriFunction));
    }

    public CamelMessageHandlerSpec endpointUriExpression(String endpointUriExpression) {
        return this.endpointUriExpression(PARSER.parseExpression(endpointUriExpression));
    }

    public CamelMessageHandlerSpec endpointUriExpression(Expression endpointUriExpression) {
        ((CamelMessageHandler)((Object)this.target)).setEndpointUriExpression(endpointUriExpression);
        return this;
    }

    protected CamelMessageHandlerSpec route(LambdaRouteBuilder route) {
        ((CamelMessageHandler)((Object)this.target)).setRoute(route);
        return this;
    }

    public CamelMessageHandlerSpec exchangePattern(ExchangePattern exchangePattern) {
        ((CamelMessageHandler)((Object)this.target)).setExchangePattern(exchangePattern);
        return this;
    }

    public CamelMessageHandlerSpec exchangePattern(Function<org.springframework.messaging.Message<?>, ExchangePattern> exchangePatternFunction) {
        return this.exchangePatternExpression((Expression)new FunctionExpression(exchangePatternFunction));
    }

    public CamelMessageHandlerSpec exchangePatternExpression(String exchangePatternExpression) {
        return this.exchangePatternExpression(PARSER.parseExpression(exchangePatternExpression));
    }

    public CamelMessageHandlerSpec exchangePatternExpression(Expression exchangePatternExpression) {
        ((CamelMessageHandler)((Object)this.target)).setExchangePatternExpression(exchangePatternExpression);
        return this;
    }

    public CamelMessageHandlerSpec inboundHeaderNames(String ... inboundHeaderNames) {
        Assert.notEmpty((Object[])inboundHeaderNames, (String)"'inboundHeaderNames' must not be empty");
        this.inboundHeaderNames = Arrays.copyOf(inboundHeaderNames, inboundHeaderNames.length);
        return this.addCamelHeaderMapper();
    }

    public CamelMessageHandlerSpec outboundHeaderNames(String ... outboundHeaderNames) {
        Assert.notEmpty((Object[])outboundHeaderNames, (String)"'outboundHeaderNames' must not be empty");
        this.outboundHeaderNames = Arrays.copyOf(outboundHeaderNames, outboundHeaderNames.length);
        return this.addCamelHeaderMapper();
    }

    private CamelMessageHandlerSpec addCamelHeaderMapper() {
        CamelHeaderMapper headerMapper = new CamelHeaderMapper();
        headerMapper.setInboundHeaderNames(this.inboundHeaderNames);
        headerMapper.setOutboundHeaderNames(this.outboundHeaderNames);
        return this.headerMapper(headerMapper);
    }

    public CamelMessageHandlerSpec headerMapper(HeaderMapper<Message> headerMapper) {
        ((CamelMessageHandler)((Object)this.target)).setHeaderMapper(headerMapper);
        return this;
    }

    public CamelMessageHandlerSpec exchangeProperties(Map<String, Object> exchangeProperties) {
        ((CamelMessageHandler)((Object)this.target)).setExchangeProperties(exchangeProperties);
        return this;
    }

    public CamelMessageHandlerSpec exchangePropertiesExpression(String exchangePropertiesExpression) {
        return this.exchangePropertiesExpression(PARSER.parseExpression(exchangePropertiesExpression));
    }

    public CamelMessageHandlerSpec exchangePropertiesExpression(Expression exchangePropertiesExpression) {
        ((CamelMessageHandler)((Object)this.target)).setExchangePropertiesExpression(exchangePropertiesExpression);
        return this;
    }
}

