/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.support;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.utils.PatternMatchUtils;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.NumberUtils;

public abstract class AbstractMessageAttributesHeaderMapper<A>
implements HeaderMapper<Map<String, A>> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile String[] outboundHeaderNames = new String[]{"!id", "!timestamp", "!nativeHeaders", "!aws_messageId", "!aws_queue", "!aws_topic", "*"};

    public void setOutboundHeaderNames(String ... outboundHeaderNames) {
        Assert.notNull((Object)outboundHeaderNames, (String)"'outboundHeaderNames' must not be null.");
        Assert.noNullElements((Object[])outboundHeaderNames, (String)"'outboundHeaderNames' must not contains null elements.");
        Arrays.sort(outboundHeaderNames);
        this.outboundHeaderNames = outboundHeaderNames;
    }

    public void fromHeaders(MessageHeaders headers, Map<String, A> target) {
        for (Map.Entry messageHeader : headers.entrySet()) {
            String messageHeaderName = (String)messageHeader.getKey();
            Object messageHeaderValue = messageHeader.getValue();
            if (!Boolean.TRUE.equals(PatternMatchUtils.smartMatch((String)messageHeaderName, (String[])this.outboundHeaderNames))) continue;
            if (messageHeaderValue instanceof UUID || messageHeaderValue instanceof MimeType || messageHeaderValue instanceof Boolean || messageHeaderValue instanceof String) {
                target.put(messageHeaderName, this.getStringMessageAttribute(messageHeaderValue.toString()));
                continue;
            }
            if (messageHeaderValue instanceof Number) {
                target.put(messageHeaderName, this.getNumberMessageAttribute(messageHeaderValue));
                continue;
            }
            if (messageHeaderValue instanceof ByteBuffer) {
                target.put(messageHeaderName, this.getBinaryMessageAttribute((ByteBuffer)messageHeaderValue));
                continue;
            }
            if (messageHeaderValue instanceof byte[]) {
                target.put(messageHeaderName, this.getBinaryMessageAttribute(ByteBuffer.wrap((byte[])messageHeaderValue)));
                continue;
            }
            if (!this.logger.isWarnEnabled()) continue;
            this.logger.warn((Object)String.format("Message header with name '%s' and type '%s' cannot be sent as message attribute because it is not supported by the current AWS service.", messageHeaderName, messageHeaderValue.getClass().getName()));
        }
    }

    private A getBinaryMessageAttribute(ByteBuffer messageHeaderValue) {
        return this.buildMessageAttribute("Binary", messageHeaderValue);
    }

    private A getStringMessageAttribute(String messageHeaderValue) {
        return this.buildMessageAttribute("String", messageHeaderValue);
    }

    private A getNumberMessageAttribute(Object messageHeaderValue) {
        Assert.isTrue((boolean)NumberUtils.STANDARD_NUMBER_TYPES.contains(messageHeaderValue.getClass()), (String)"Only standard number types are accepted as message header.");
        return this.buildMessageAttribute("Number." + messageHeaderValue.getClass().getName(), messageHeaderValue);
    }

    protected abstract A buildMessageAttribute(String var1, Object var2);

    public Map<String, Object> toHeaders(Map<String, A> source) {
        throw new UnsupportedOperationException("The mapping from AWS Response Message is not supported");
    }
}

