/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.outbound;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.aws.outbound.AbstractAwsMessageHandler;
import org.springframework.integration.aws.outbound.ConvertingFromMessageConverter;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.mapping.OutboundMessageMapper;
import org.springframework.integration.support.MutableMessage;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;

public class KinesisMessageHandler
extends AbstractAwsMessageHandler<Void> {
    private final KinesisAsyncClient amazonKinesis;
    private MessageConverter messageConverter = new ConvertingFromMessageConverter((Converter<Object, ?>)new SerializingConverter());
    private Expression streamExpression;
    private Expression partitionKeyExpression;
    private Expression explicitHashKeyExpression;
    private Expression sequenceNumberExpression;
    private OutboundMessageMapper<byte[]> embeddedHeadersMapper;

    public KinesisMessageHandler(KinesisAsyncClient amazonKinesis) {
        Assert.notNull((Object)amazonKinesis, (String)"'amazonKinesis' must not be null.");
        this.amazonKinesis = amazonKinesis;
    }

    @Deprecated
    public void setConverter(Converter<Object, byte[]> converter) {
        this.setMessageConverter(new ConvertingFromMessageConverter(converter));
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null.");
        this.messageConverter = messageConverter;
    }

    public void setStream(String stream) {
        this.setStreamExpression((Expression)new LiteralExpression(stream));
    }

    public void setStreamExpressionString(String streamExpression) {
        this.setStreamExpression(EXPRESSION_PARSER.parseExpression(streamExpression));
    }

    public void setStreamExpression(Expression streamExpression) {
        this.streamExpression = streamExpression;
    }

    public void setPartitionKey(String partitionKey) {
        this.setPartitionKeyExpression((Expression)new LiteralExpression(partitionKey));
    }

    public void setPartitionKeyExpressionString(String partitionKeyExpression) {
        this.setPartitionKeyExpression(EXPRESSION_PARSER.parseExpression(partitionKeyExpression));
    }

    public void setPartitionKeyExpression(Expression partitionKeyExpression) {
        this.partitionKeyExpression = partitionKeyExpression;
    }

    public void setExplicitHashKey(String explicitHashKey) {
        this.setExplicitHashKeyExpression((Expression)new LiteralExpression(explicitHashKey));
    }

    public void setExplicitHashKeyExpressionString(String explicitHashKeyExpression) {
        this.setExplicitHashKeyExpression(EXPRESSION_PARSER.parseExpression(explicitHashKeyExpression));
    }

    public void setExplicitHashKeyExpression(Expression explicitHashKeyExpression) {
        this.explicitHashKeyExpression = explicitHashKeyExpression;
    }

    public void setSequenceNumberExpressionString(String sequenceNumberExpression) {
        this.setSequenceNumberExpression(EXPRESSION_PARSER.parseExpression(sequenceNumberExpression));
    }

    public void setSequenceNumberExpression(Expression sequenceNumberExpression) {
        this.sequenceNumberExpression = sequenceNumberExpression;
    }

    public void setEmbeddedHeadersMapper(OutboundMessageMapper<byte[]> embeddedHeadersMapper) {
        this.embeddedHeadersMapper = embeddedHeadersMapper;
    }

    @Override
    public void setHeaderMapper(HeaderMapper<Void> headerMapper) {
        throw new UnsupportedOperationException("Kinesis doesn't support headers.\nConsider to use 'OutboundMessageMapper<byte[]>' for embedding headers into the record data.");
    }

    @Override
    protected AwsRequest messageToAwsRequest(Message<?> message) {
        PutRecordRequest putRecordRequest;
        Object object = message.getPayload();
        if (object instanceof PutRecordsRequest) {
            PutRecordsRequest putRecordsRequest = (PutRecordsRequest)object;
            return putRecordsRequest;
        }
        Object object2 = message.getPayload();
        return object2 instanceof PutRecordRequest ? (putRecordRequest = (PutRecordRequest)object2) : this.buildPutRecordRequest(message);
    }

    private PutRecordRequest buildPutRecordRequest(Message<?> message) {
        MessageHeaders messageHeaders = message.getHeaders();
        String stream = (String)messageHeaders.get((Object)"aws_stream", String.class);
        if (!StringUtils.hasText((String)stream) && this.streamExpression != null) {
            stream = (String)this.streamExpression.getValue(this.getEvaluationContext(), message, String.class);
        }
        Assert.state((stream != null ? 1 : 0) != 0, (String)"'stream' must not be null for sending a Kinesis record. Consider configuring this handler with a 'stream'( or 'streamExpression') or supply an 'aws_stream' message header.");
        String partitionKey = (String)messageHeaders.get((Object)"aws_partitionKey", String.class);
        if (!StringUtils.hasText((String)partitionKey) && this.partitionKeyExpression != null) {
            partitionKey = (String)this.partitionKeyExpression.getValue(this.getEvaluationContext(), message, String.class);
        }
        Assert.state((partitionKey != null ? 1 : 0) != 0, (String)"'partitionKey' must not be null for sending a Kinesis record. Consider configuring this handler with a 'partitionKey'( or 'partitionKeyExpression') or supply an 'aws_partitionKey' message header.");
        String explicitHashKey = this.explicitHashKeyExpression != null ? (String)this.explicitHashKeyExpression.getValue(this.getEvaluationContext(), message, String.class) : null;
        String sequenceNumber = (String)messageHeaders.get((Object)"aws_sequenceNumber", String.class);
        if (!StringUtils.hasText((String)sequenceNumber) && this.sequenceNumberExpression != null) {
            sequenceNumber = (String)this.sequenceNumberExpression.getValue(this.getEvaluationContext(), message, String.class);
        }
        Object payload = message.getPayload();
        SdkBytes data = null;
        MutableMessage messageToEmbed = null;
        if (payload instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)payload;
            data = SdkBytes.fromByteBuffer((ByteBuffer)byteBuffer);
            if (this.embeddedHeadersMapper != null) {
                messageToEmbed = new MutableMessage((Object)data.asByteArray(), (Map)messageHeaders);
            }
        } else {
            byte[] bytes = (byte[])(payload instanceof byte[] ? payload : this.messageConverter.fromMessage(message, byte[].class));
            Assert.notNull((Object)bytes, (String)"payload cannot be null");
            if (this.embeddedHeadersMapper != null) {
                messageToEmbed = new MutableMessage((Object)bytes, (Map)messageHeaders);
            } else {
                data = SdkBytes.fromByteArray((byte[])bytes);
            }
        }
        if (messageToEmbed != null) {
            try {
                byte[] bytes = (byte[])this.embeddedHeadersMapper.fromMessage((Message)messageToEmbed);
                Assert.notNull((Object)bytes, (String)"payload cannot be null");
                data = SdkBytes.fromByteArray((byte[])bytes);
            }
            catch (Exception ex) {
                throw new MessageConversionException(message, "Cannot embedded headers to payload", (Throwable)ex);
            }
        }
        return (PutRecordRequest)PutRecordRequest.builder().streamName(stream).partitionKey(partitionKey).explicitHashKey(explicitHashKey).sequenceNumberForOrdering(sequenceNumber).data(data).build();
    }

    @Override
    protected CompletableFuture<? extends AwsResponse> handleMessageToAws(Message<?> message, AwsRequest request) {
        if (request instanceof PutRecordsRequest) {
            PutRecordsRequest putRecordsRequest = (PutRecordsRequest)request;
            return this.amazonKinesis.putRecords(putRecordsRequest);
        }
        return this.amazonKinesis.putRecord((PutRecordRequest)request);
    }

    @Override
    @Nullable
    protected Map<String, ?> additionalOnSuccessHeaders(AwsRequest request, AwsResponse response) {
        if (response instanceof PutRecordResponse) {
            PutRecordResponse putRecordResponse = (PutRecordResponse)response;
            return Map.of("aws_shard", putRecordResponse.shardId(), "aws_sequenceNumber", putRecordResponse.sequenceNumber());
        }
        return null;
    }
}

