/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.metadata;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.util.Assert;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest;

public class DynamoDbMetadataStore
implements ConcurrentMetadataStore,
InitializingBean {
    private static final Log logger = LogFactory.getLog(DynamoDbMetadataStore.class);
    public static final String DEFAULT_TABLE_NAME = "SpringIntegrationMetadataStore";
    public static final String KEY = "metadataKey";
    public static final String VALUE = "metadataValue";
    public static final String TTL = "expireAt";
    private static final String KEY_NOT_EXISTS_EXPRESSION = String.format("attribute_not_exists(%s)", "metadataKey");
    private final DynamoDbAsyncClient dynamoDB;
    private final String tableName;
    private final CountDownLatch createTableLatch = new CountDownLatch(1);
    private int createTableRetries = 25;
    private int createTableDelay = 1;
    private BillingMode billingMode = BillingMode.PAY_PER_REQUEST;
    private long readCapacity = 1L;
    private long writeCapacity = 1L;
    private Integer timeToLive;
    private volatile boolean initialized;

    public DynamoDbMetadataStore(DynamoDbAsyncClient dynamoDB) {
        this(dynamoDB, DEFAULT_TABLE_NAME);
    }

    public DynamoDbMetadataStore(DynamoDbAsyncClient dynamoDB, String tableName) {
        Assert.notNull((Object)dynamoDB, (String)"'dynamoDB' must not be null.");
        Assert.hasText((String)tableName, (String)"'tableName' must not be empty.");
        this.dynamoDB = dynamoDB;
        this.tableName = tableName;
    }

    public void setCreateTableRetries(int createTableRetries) {
        this.createTableRetries = createTableRetries;
    }

    public void setCreateTableDelay(int createTableDelay) {
        this.createTableDelay = createTableDelay;
    }

    public void setBillingMode(BillingMode billingMode) {
        Assert.notNull((Object)billingMode, (String)"'billingMode' must not be null");
        this.billingMode = billingMode;
    }

    public void setReadCapacity(long readCapacity) {
        this.readCapacity = readCapacity;
    }

    public void setWriteCapacity(long writeCapacity) {
        this.writeCapacity = writeCapacity;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void afterPropertiesSet() {
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.dynamoDB.describeTable(request -> request.tableName(this.tableName)).thenRun(() -> {})).exceptionallyCompose(ex -> {
            Throwable cause = ex.getCause();
            if (cause instanceof ResourceNotFoundException) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("No table '" + this.tableName + "'. Creating one..."));
                }
                return this.createTable();
            }
            return (CompletionStage)DynamoDbMetadataStore.rethrowAsRuntimeException(cause);
        })).thenCompose(result -> this.updateTimeToLiveIfAny())).exceptionally(ex -> {
            logger.error((Object)("Cannot create DynamoDb table: " + this.tableName), ex.getCause());
            return null;
        })).thenRun(this.createTableLatch::countDown);
        this.initialized = true;
    }

    private CompletableFuture<Void> createTable() {
        CreateTableRequest.Builder createTableRequest = CreateTableRequest.builder().tableName(this.tableName).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName(KEY).keyType(KeyType.HASH).build()}).attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName(KEY).attributeType(ScalarAttributeType.S).build()}).billingMode(this.billingMode);
        if (BillingMode.PROVISIONED.equals((Object)this.billingMode)) {
            createTableRequest.provisionedThroughput((ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(Long.valueOf(this.readCapacity)).writeCapacityUnits(Long.valueOf(this.writeCapacity)).build());
        }
        return ((CompletableFuture)this.dynamoDB.createTable((CreateTableRequest)createTableRequest.build()).thenCompose(result -> this.dynamoDB.waiter().waitUntilTableExists(request -> request.tableName(this.tableName), waiter -> waiter.maxAttempts(Integer.valueOf(this.createTableRetries)).backoffStrategy((BackoffStrategy)FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(this.createTableDelay)))))).thenRun(() -> {});
    }

    private CompletableFuture<?> updateTimeToLiveIfAny() {
        if (this.timeToLive != null) {
            UpdateTimeToLiveRequest.Builder updateTimeToLiveRequest = UpdateTimeToLiveRequest.builder().tableName(this.tableName).timeToLiveSpecification(ttl -> ttl.attributeName(TTL).enabled(Boolean.valueOf(this.timeToLive > 0)));
            return this.dynamoDB.updateTimeToLive((UpdateTimeToLiveRequest)updateTimeToLiveRequest.build()).exceptionally(ex -> {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)"The error during 'updateTimeToLive' request", ex);
                }
                return null;
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    private void awaitForActive() {
        Assert.state((boolean)this.initialized, () -> "The component has not been initialized: " + this + ".\n Is it declared as a bean?");
        try {
            this.createTableLatch.await(this.createTableRetries * this.createTableDelay, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("The DynamoDb table " + this.tableName + " has not been created during " + this.createTableRetries * this.createTableDelay + " seconds");
        }
    }

    public void put(String key, String value) {
        Assert.hasText((String)key, (String)"'key' must not be empty.");
        Assert.hasText((String)value, (String)"'value' must not be empty.");
        this.awaitForActive();
        HashMap<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();
        attributes.put(KEY, AttributeValue.fromS((String)key));
        attributes.put(VALUE, AttributeValue.fromS((String)value));
        if (this.timeToLive != null && this.timeToLive > 0) {
            attributes.put(TTL, AttributeValue.fromN((String)("" + Instant.now().plusMillis(this.timeToLive.intValue()).getEpochSecond())));
        }
        PutItemRequest.Builder putItemRequest = PutItemRequest.builder().tableName(this.tableName).item(attributes);
        this.dynamoDB.putItem((PutItemRequest)putItemRequest.build()).join();
    }

    public String get(String key) {
        Assert.hasText((String)key, (String)"'key' must not be empty.");
        this.awaitForActive();
        try {
            return (String)((CompletableFuture)((CompletableFuture)this.dynamoDB.getItem(request -> request.tableName(this.tableName).key(Map.of(KEY, AttributeValue.fromS((String)key)))).thenApply(GetItemResponse::item)).thenApply(DynamoDbMetadataStore::getValueIfAny)).join();
        }
        catch (CompletionException ex) {
            return (String)DynamoDbMetadataStore.rethrowAsRuntimeException(ex.getCause());
        }
    }

    public String putIfAbsent(String key, String value) {
        Assert.hasText((String)key, (String)"'key' must not be empty.");
        Assert.hasText((String)value, (String)"'value' must not be empty.");
        this.awaitForActive();
        HashMap<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();
        attributes.put(":value", AttributeValue.fromS((String)value));
        Object updateExpression = "SET metadataValue = :value";
        if (this.timeToLive != null && this.timeToLive > 0) {
            updateExpression = (String)updateExpression + ", expireAt = :ttl";
            attributes.put(":ttl", AttributeValue.fromN((String)("" + Instant.now().plusMillis(this.timeToLive.intValue()).getEpochSecond())));
        }
        UpdateItemRequest.Builder updateItemRequest = UpdateItemRequest.builder().tableName(this.tableName).key(Map.of(KEY, AttributeValue.fromS((String)key))).conditionExpression(KEY_NOT_EXISTS_EXPRESSION).updateExpression((String)updateExpression).expressionAttributeValues(attributes);
        try {
            this.dynamoDB.updateItem((UpdateItemRequest)updateItemRequest.build()).join();
            return null;
        }
        catch (CompletionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ConditionalCheckFailedException) {
                return this.get(key);
            }
            return (String)DynamoDbMetadataStore.rethrowAsRuntimeException(cause);
        }
    }

    public boolean replace(String key, String oldValue, String newValue) {
        Assert.hasText((String)key, (String)"'key' must not be empty.");
        Assert.hasText((String)oldValue, (String)"'value' must not be empty.");
        Assert.hasText((String)newValue, (String)"'newValue' must not be empty.");
        this.awaitForActive();
        HashMap<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();
        attributes.put(":newValue", AttributeValue.fromS((String)newValue));
        attributes.put(":oldValue", AttributeValue.fromS((String)oldValue));
        Object updateExpression = "SET metadataValue = :newValue";
        if (this.timeToLive != null && this.timeToLive > 0) {
            updateExpression = (String)updateExpression + ", expireAt = :ttl";
            attributes.put(":ttl", AttributeValue.fromN((String)("" + Instant.now().plusMillis(this.timeToLive.intValue()).getEpochSecond())));
        }
        UpdateItemRequest.Builder updateItemRequest = UpdateItemRequest.builder().tableName(this.tableName).key(Map.of(KEY, AttributeValue.fromS((String)key))).conditionExpression("metadataValue = :oldValue").updateExpression((String)updateExpression).expressionAttributeValues(attributes).returnValues(ReturnValue.UPDATED_NEW);
        try {
            return ((UpdateItemResponse)this.dynamoDB.updateItem((UpdateItemRequest)updateItemRequest.build()).join()).hasAttributes();
        }
        catch (CompletionException ex) {
            if (ex.getCause() instanceof ConditionalCheckFailedException) {
                return false;
            }
            return (Boolean)DynamoDbMetadataStore.rethrowAsRuntimeException(ex.getCause());
        }
    }

    public String remove(String key) {
        Assert.hasText((String)key, (String)"'key' must not be empty.");
        this.awaitForActive();
        try {
            return (String)((CompletableFuture)((CompletableFuture)this.dynamoDB.deleteItem(request -> request.tableName(this.tableName).key(Map.of(KEY, AttributeValue.fromS((String)key))).returnValues(ReturnValue.ALL_OLD)).thenApply(DeleteItemResponse::attributes)).thenApply(DynamoDbMetadataStore::getValueIfAny)).join();
        }
        catch (CompletionException ex) {
            return (String)DynamoDbMetadataStore.rethrowAsRuntimeException(ex.getCause());
        }
    }

    private static String getValueIfAny(Map<String, AttributeValue> item) {
        if (item.containsKey(VALUE)) {
            return item.get(VALUE).s();
        }
        return null;
    }

    private static <T> T rethrowAsRuntimeException(Throwable cause) {
        if (cause instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)cause;
            throw runtimeException;
        }
        throw new IllegalStateException(cause);
    }

    public String toString() {
        return "DynamoDbMetadataStore{table=" + this.tableName + ", createTableRetries=" + this.createTableRetries + ", createTableDelay=" + this.createTableDelay + ", billingMode=" + this.billingMode + ", readCapacity=" + this.readCapacity + ", writeCapacity=" + this.writeCapacity + ", timeToLive=" + this.timeToLive + "}";
    }
}

