/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.support;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.integration.aws.support.S3Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.session.SharedSessionCapable;
import org.springframework.util.Assert;

public class S3SessionFactory
implements SessionFactory<S3ObjectSummary>,
SharedSessionCapable {
    private final S3Session s3Session;

    public S3SessionFactory() {
        this(AmazonS3ClientBuilder.defaultClient());
    }

    public S3SessionFactory(AmazonS3 amazonS3) {
        this(amazonS3, null);
    }

    public S3SessionFactory(AmazonS3 amazonS3, ResourceIdResolver resourceIdResolver) {
        Assert.notNull((Object)amazonS3, (String)"'amazonS3' must not be null.");
        this.s3Session = new S3Session(amazonS3, resourceIdResolver);
    }

    public S3Session getSession() {
        return this.s3Session;
    }

    public boolean isSharedSession() {
        return true;
    }

    public void resetSharedSession() {
    }

    public void setEndpoint(String endpoint) {
        this.s3Session.setEndpoint(endpoint);
    }
}

