/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.outbound;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.ReturnedMessage;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.context.Lifecycle;
import org.springframework.integration.IntegrationPatternType;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.integration.amqp.outbound.AbstractAmqpOutboundEndpoint;
import org.springframework.integration.amqp.support.MappingUtils;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class AmqpOutboundEndpoint
extends AbstractAmqpOutboundEndpoint
implements RabbitTemplate.ConfirmCallback,
RabbitTemplate.ReturnsCallback {
    private static final Duration DEFAULT_CONFIRM_TIMEOUT = Duration.ofSeconds(5L);
    private final AmqpTemplate amqpTemplate;
    private final @Nullable RabbitTemplate rabbitTemplate;
    private boolean expectReply;
    private boolean waitForConfirm;
    private Duration waitForConfirmTimeout = DEFAULT_CONFIRM_TIMEOUT;
    private boolean multiSend;

    public AmqpOutboundEndpoint(AmqpTemplate amqpTemplate) {
        Assert.notNull((Object)amqpTemplate, (String)"amqpTemplate must not be null");
        this.amqpTemplate = amqpTemplate;
        if (amqpTemplate instanceof RabbitTemplate) {
            RabbitTemplate castRabbitTemplate = (RabbitTemplate)amqpTemplate;
            this.setConnectionFactory(castRabbitTemplate.getConnectionFactory());
            this.rabbitTemplate = castRabbitTemplate;
        } else {
            this.rabbitTemplate = null;
        }
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setWaitForConfirm(boolean waitForConfirm) {
        this.waitForConfirm = waitForConfirm;
    }

    public String getComponentType() {
        return this.expectReply ? "amqp:outbound-gateway" : "amqp:outbound-channel-adapter";
    }

    public void setMultiSend(boolean multiSend) {
        Assert.isTrue((this.rabbitTemplate != null && (!this.waitForConfirm || this.rabbitTemplate.getConnectionFactory().isSimplePublisherConfirms()) ? 1 : 0) != 0, () -> "To use multiSend, " + String.valueOf(this.amqpTemplate) + " must be a RabbitTemplate with a ConnectionFactory configured with simple confirms");
        this.multiSend = multiSend;
    }

    public IntegrationPatternType getIntegrationPatternType() {
        return this.expectReply ? super.getIntegrationPatternType() : IntegrationPatternType.outbound_channel_adapter;
    }

    @Override
    public @Nullable RabbitTemplate getRabbitTemplate() {
        return this.rabbitTemplate;
    }

    @Override
    protected void endpointInit() {
        Duration confirmTimeout;
        if (this.getConfirmCorrelationExpression() != null) {
            Assert.notNull((Object)this.rabbitTemplate, (String)"RabbitTemplate implementation is required for publisher confirms");
            this.rabbitTemplate.setConfirmCallback((RabbitTemplate.ConfirmCallback)this);
            if (!this.rabbitTemplate.getConnectionFactory().isPublisherConfirms()) {
                this.logger.warn((CharSequence)"A confirm correlation expression is provided but the underlying connection factory does not support correlated delivery confirmations; no confirmations will be received");
            }
        }
        if (this.getReturnChannel() != null) {
            Assert.notNull((Object)this.rabbitTemplate, (String)"RabbitTemplate implementation is required for publisher confirms");
            this.rabbitTemplate.setReturnsCallback((RabbitTemplate.ReturnsCallback)this);
            if (!this.rabbitTemplate.getConnectionFactory().isPublisherReturns()) {
                this.logger.warn((CharSequence)"A return channel is provided but the underlying connection factory does not support returned messages; none will be received");
            }
        }
        if ((confirmTimeout = this.getConfirmTimeout()) != null) {
            this.waitForConfirmTimeout = confirmTimeout;
        }
    }

    @Override
    protected void doStop() {
        AmqpTemplate amqpTemplate = this.amqpTemplate;
        if (amqpTemplate instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)amqpTemplate;
            lifecycle.stop();
        }
    }

    protected @Nullable Object handleRequestMessage(Message<?> requestMessage) {
        CorrelationData correlationData = this.generateCorrelationData(requestMessage);
        String exchangeName = this.generateExchangeName(requestMessage);
        String routingKey = this.generateRoutingKey(requestMessage);
        if (this.expectReply) {
            return this.sendAndReceive(exchangeName, routingKey, requestMessage, correlationData);
        }
        if (this.multiSend && requestMessage.getPayload() instanceof Iterable) {
            this.multiSend(requestMessage, exchangeName, routingKey);
            return null;
        }
        this.send(exchangeName, routingKey, requestMessage, correlationData);
        if (this.waitForConfirm && correlationData != null) {
            this.waitForConfirm(requestMessage, correlationData);
        }
        return null;
    }

    private void multiSend(Message<?> requestMessage, @Nullable String exchangeName, @Nullable String routingKey) {
        ((Iterable)requestMessage.getPayload()).forEach(payload -> Assert.state((boolean)(payload instanceof Message), (String)"To use multiSend, the payload must be an Iterable<Message<?>>"));
        RabbitTemplate rabbitTemplateToUse = this.rabbitTemplate;
        Assert.notNull((Object)rabbitTemplateToUse, (String)"The 'RabbitTemplate' must be provided for multi-send.");
        rabbitTemplateToUse.invoke(template -> {
            ((Iterable)requestMessage.getPayload()).forEach(message -> this.doRabbitSend(exchangeName, routingKey, (Message<?>)message, null, rabbitTemplateToUse));
            if (this.waitForConfirm) {
                template.waitForConfirmsOrDie(this.waitForConfirmTimeout.toMillis());
            }
            return null;
        });
    }

    private void waitForConfirm(Message<?> requestMessage, CorrelationData correlationData) {
        try {
            CorrelationData.Confirm confirm = (CorrelationData.Confirm)correlationData.getFuture().get(this.waitForConfirmTimeout.toMillis(), TimeUnit.MILLISECONDS);
            if (!confirm.ack()) {
                throw new AmqpException("Negative publisher confirm received: " + String.valueOf(confirm));
            }
            if (correlationData.getReturned() != null) {
                throw new AmqpException("Message was returned by the broker");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new AmqpException("Failed to get publisher confirm", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new MessageTimeoutException(requestMessage, String.valueOf((Object)this) + ": Timed out awaiting publisher confirm", (Throwable)e);
        }
    }

    private void send(@Nullable String exchangeName, @Nullable String routingKey, Message<?> requestMessage, @Nullable CorrelationData correlationData) {
        if (this.rabbitTemplate != null) {
            this.doRabbitSend(exchangeName, routingKey, requestMessage, correlationData, this.rabbitTemplate);
        } else {
            this.amqpTemplate.convertAndSend(exchangeName, routingKey, requestMessage.getPayload(), message -> {
                this.getHeaderMapper().fromHeadersToRequest(requestMessage.getHeaders(), message.getMessageProperties());
                return message;
            });
        }
    }

    private void doRabbitSend(@Nullable String exchangeName, @Nullable String routingKey, Message<?> requestMessage, @Nullable CorrelationData correlationData, RabbitTemplate template) {
        MessageConverter converter = template.getMessageConverter();
        org.springframework.amqp.core.Message amqpMessage = MappingUtils.mapMessage(requestMessage, converter, this.getHeaderMapper(), this.getDefaultDeliveryMode(), this.isHeadersMappedLast());
        this.addDelayProperty(requestMessage, amqpMessage);
        template.send(exchangeName, routingKey, amqpMessage, correlationData);
    }

    private @Nullable AbstractIntegrationMessageBuilder<?> sendAndReceive(@Nullable String exchangeName, @Nullable String routingKey, Message<?> requestMessage, @Nullable CorrelationData correlationData) {
        Assert.state((this.rabbitTemplate != null ? 1 : 0) != 0, (String)"RabbitTemplate implementation is required for publisher confirms");
        MessageConverter converter = this.rabbitTemplate.getMessageConverter();
        org.springframework.amqp.core.Message amqpMessage = MappingUtils.mapMessage(requestMessage, converter, this.getHeaderMapper(), this.getDefaultDeliveryMode(), this.isHeadersMappedLast());
        this.addDelayProperty(requestMessage, amqpMessage);
        org.springframework.amqp.core.Message amqpReplyMessage = this.rabbitTemplate.sendAndReceive(exchangeName, routingKey, amqpMessage, correlationData);
        if (amqpReplyMessage == null) {
            return null;
        }
        return this.buildReply(converter, amqpReplyMessage);
    }

    public void confirm(@Nullable CorrelationData correlationData, boolean ack, @Nullable String cause) {
        this.handleConfirm(correlationData, ack, cause);
    }

    public void returnedMessage(ReturnedMessage returnedMessage) {
        Assert.state((this.rabbitTemplate != null ? 1 : 0) != 0, (String)"RabbitTemplate implementation is required for publisher confirms");
        MessageConverter converter = this.rabbitTemplate.getMessageConverter();
        Message<?> returned = this.buildReturnedMessage(returnedMessage, converter);
        Objects.requireNonNull(this.getReturnChannel()).send(returned);
    }
}

