/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.inbound;

import com.rabbitmq.client.amqp.Resource;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import org.aopalliance.aop.Advice;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbitmq.client.AmqpConnectionFactory;
import org.springframework.amqp.rabbitmq.client.listener.RabbitAmqpListenerContainer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.amqp.support.postprocessor.MessagePostProcessorUtils;
import org.springframework.integration.amqp.inbound.IntegrationRabbitAmqpMessageListener;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.core.Pausable;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.messaging.Message;
import org.springframework.scheduling.TaskScheduler;

public class AmqpClientMessageProducer
extends MessageProducerSupport
implements Pausable {
    private final RabbitAmqpListenerContainer listenerContainer;
    private @Nullable MessageConverter messageConverter = new SimpleMessageConverter();
    private AmqpHeaderMapper headerMapper = DefaultAmqpHeaderMapper.inboundMapper();
    private @Nullable Collection<MessagePostProcessor> afterReceivePostProcessors;
    private volatile boolean paused;

    public AmqpClientMessageProducer(AmqpConnectionFactory connectionFactory, String ... queueNames) {
        this.listenerContainer = new RabbitAmqpListenerContainer(connectionFactory);
        this.listenerContainer.setQueueNames(queueNames);
    }

    public void setInitialCredits(int initialCredits) {
        this.listenerContainer.setInitialCredits(initialCredits);
    }

    public void setPriority(int priority) {
        this.listenerContainer.setPriority(priority);
    }

    public void setStateListeners(Resource.StateListener ... stateListeners) {
        this.listenerContainer.setStateListeners(stateListeners);
    }

    public void setAfterReceivePostProcessors(MessagePostProcessor ... afterReceivePostProcessors) {
        this.afterReceivePostProcessors = MessagePostProcessorUtils.sort(Arrays.asList(afterReceivePostProcessors));
    }

    public void setBatchSize(int batchSize) {
        this.listenerContainer.setBatchSize(batchSize);
    }

    public void setBatchReceiveTimeout(long batchReceiveTimeout) {
        this.listenerContainer.setBatchReceiveTimeout(batchReceiveTimeout);
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.listenerContainer.setTaskScheduler(taskScheduler);
    }

    public void setAdviceChain(Advice ... advices) {
        this.listenerContainer.setAdviceChain(advices);
    }

    public void setAutoSettle(boolean autoSettle) {
        this.listenerContainer.setAutoSettle(autoSettle);
    }

    public void setDefaultRequeue(boolean defaultRequeue) {
        this.listenerContainer.setDefaultRequeue(defaultRequeue);
    }

    public void setGracefulShutdownPeriod(Duration gracefulShutdownPeriod) {
        this.listenerContainer.setGracefulShutdownPeriod(gracefulShutdownPeriod);
    }

    public void setConsumersPerQueue(int consumersPerQueue) {
        this.listenerContainer.setConsumersPerQueue(consumersPerQueue);
    }

    public void setMessageConverter(@Nullable MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public String getComponentType() {
        return "amqp:inbound-channel-adapter";
    }

    protected void onInit() {
        super.onInit();
        this.listenerContainer.setBeanName(this.getComponentName() + ".listenerContainer");
        IntegrationRabbitAmqpMessageListener messageListener = new IntegrationRabbitAmqpMessageListener((NamedComponent)this, this::processRequest, this.headerMapper, this.messageConverter, this.afterReceivePostProcessors);
        this.listenerContainer.setupMessageListener((MessageListener)messageListener);
        this.listenerContainer.afterPropertiesSet();
    }

    protected void doStart() {
        super.doStart();
        this.listenerContainer.start();
    }

    protected void doStop() {
        super.doStop();
        this.listenerContainer.stop();
    }

    public void destroy() {
        super.destroy();
        this.listenerContainer.destroy();
    }

    public void pause() {
        this.listenerContainer.pause();
        this.paused = true;
    }

    public void resume() {
        this.listenerContainer.resume();
        this.paused = false;
    }

    public boolean isPaused() {
        return this.paused;
    }

    private void processRequest(Message<?> messageToSend, @Nullable org.springframework.amqp.core.Message requestMessage) {
        this.sendMessage(messageToSend);
    }
}

