/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.outbound;

import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.AsyncAmqpTemplate;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.amqp.support.converter.SmartMessageConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.mapping.AbstractHeaderMapper;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AmqpClientMessageHandler
extends AbstractReplyProducingMessageHandler {
    private final AsyncAmqpTemplate amqpTemplate;
    private AmqpHeaderMapper headerMapper = DefaultAmqpHeaderMapper.outboundMapper();
    private MessageConverter messageConverter = new SimpleMessageConverter();
    private @Nullable Expression exchangeExpression;
    private @Nullable Expression routingKeyExpression;
    private @Nullable Expression queueExpression;
    private @Nullable Expression replyPayloadTypeExpression;
    private boolean returnMessage;
    private StandardEvaluationContext evaluationContext;

    public AmqpClientMessageHandler(AsyncAmqpTemplate amqpTemplate) {
        this.amqpTemplate = amqpTemplate;
        this.setAsync(true);
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setExchange(String exchange) {
        this.setExchangeExpression((Expression)new ValueExpression((Object)exchange));
    }

    public void setExchangeExpressionString(String exchangeExpression) {
        this.setExchangeExpression(EXPRESSION_PARSER.parseExpression(exchangeExpression));
    }

    public void setExchangeExpression(Expression exchangeExpression) {
        this.exchangeExpression = exchangeExpression;
    }

    public void setRoutingKey(String routingKey) {
        this.setRoutingKeyExpression((Expression)new ValueExpression((Object)routingKey));
    }

    public void setRoutingKeyExpressionString(String routingKeyExpression) {
        this.setRoutingKeyExpression(EXPRESSION_PARSER.parseExpression(routingKeyExpression));
    }

    public void setRoutingKeyExpression(Expression routingKeyExpression) {
        this.routingKeyExpression = routingKeyExpression;
    }

    public void setQueue(String queue) {
        this.setQueueExpression((Expression)new ValueExpression((Object)queue));
    }

    public void setQueueExpressionString(String queueExpression) {
        this.setQueueExpression(EXPRESSION_PARSER.parseExpression(queueExpression));
    }

    public void setQueueExpression(Expression queueExpression) {
        this.queueExpression = queueExpression;
    }

    public void setReplyPayloadType(Class<?> replyPayloadType) {
        this.setReplyPayloadType(ResolvableType.forClass(replyPayloadType));
    }

    public void setReplyPayloadType(ResolvableType replyPayloadType) {
        this.setReplyPayloadTypeExpression((Expression)new ValueExpression((Object)replyPayloadType));
    }

    public void setReplyPayloadTypeExpressionString(String replyPayloadTypeExpression) {
        this.setReplyPayloadTypeExpression(EXPRESSION_PARSER.parseExpression(replyPayloadTypeExpression));
    }

    public void setReplyPayloadTypeExpression(Expression replyPayloadTypeExpression) {
        this.replyPayloadTypeExpression = replyPayloadTypeExpression;
    }

    public void setReturnMessage(boolean returnMessage) {
        this.returnMessage = returnMessage;
    }

    public String getComponentType() {
        return this.getRequiresReply() ? "amqp:outbound-gateway" : "amqp:outbound-channel-adapter";
    }

    protected void doInit() {
        super.doInit();
        AmqpHeaderMapper amqpHeaderMapper = this.headerMapper;
        if (amqpHeaderMapper instanceof AbstractHeaderMapper) {
            AbstractHeaderMapper abstractHeaderMapper = (AbstractHeaderMapper)amqpHeaderMapper;
            abstractHeaderMapper.setBeanClassLoader(this.getBeanClassLoader());
        }
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        Assert.state((this.exchangeExpression == null || this.queueExpression == null ? 1 : 0) != 0, (String)"The 'exchange' (and optional 'routingKey') is mutually exclusive with 'queue'");
        Assert.state((this.replyPayloadTypeExpression == null || this.messageConverter instanceof SmartMessageConverter ? 1 : 0) != 0, (String)"The 'messageConverter' must be a 'SmartMessageConverter' when 'replyPayloadTypeExpression' is provided");
        Assert.state((this.replyPayloadTypeExpression == null || !this.returnMessage ? 1 : 0) != 0, (String)"The 'returnMessage == true' and 'replyPayloadTypeExpression' are mutually exclusive");
    }

    protected @Nullable Object handleRequestMessage(Message<?> requestMessage) {
        MessageProperties messageProperties = new MessageProperties();
        this.headerMapper.fromHeadersToRequest(requestMessage.getHeaders(), messageProperties);
        org.springframework.amqp.core.Message amqpMessage = this.messageConverter.toMessage(requestMessage.getPayload(), messageProperties);
        String queue = null;
        if (this.queueExpression != null) {
            queue = (String)this.queueExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage, String.class);
        }
        String exchange = null;
        if (this.exchangeExpression != null) {
            exchange = (String)this.exchangeExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage, String.class);
        }
        String routingKey = null;
        if (this.routingKeyExpression != null) {
            routingKey = (String)this.routingKeyExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage, String.class);
        }
        if (this.getRequiresReply()) {
            return this.doSendAndReceive(requestMessage, amqpMessage, queue, exchange, routingKey);
        }
        this.doSend(requestMessage, amqpMessage, queue, exchange, routingKey);
        return null;
    }

    private void doSend(Message<?> requestMessage, org.springframework.amqp.core.Message amqpMessage, @Nullable String queue, @Nullable String exchange, @Nullable String routingKey) {
        CompletableFuture sendResultFuture = StringUtils.hasText((String)queue) ? this.amqpTemplate.send(queue, amqpMessage) : (StringUtils.hasText((String)exchange) ? this.amqpTemplate.send(exchange, routingKey, amqpMessage) : this.amqpTemplate.send(amqpMessage));
        if (this.isAsync()) {
            sendResultFuture.whenComplete((aBoolean, throwable) -> {
                if (throwable != null) {
                    this.sendErrorMessage((Message)requestMessage, (Throwable)throwable);
                }
            });
        } else {
            sendResultFuture.join();
        }
    }

    private Object doSendAndReceive(Message<?> requestMessage, org.springframework.amqp.core.Message amqpMessage, @Nullable String queue, @Nullable String exchange, @Nullable String routingKey) {
        ParameterizedTypeReference replyType = null;
        if (this.replyPayloadTypeExpression != null) {
            ResolvableType resolvableType;
            Object type = this.replyPayloadTypeExpression.getValue((EvaluationContext)this.evaluationContext, requestMessage);
            Assert.state((type instanceof Class || type instanceof ResolvableType ? 1 : 0) != 0, (String)"The 'replyPayloadTypeExpression' must evaluate to 'Class' or 'ResolvableType'");
            if (type instanceof Class) {
                Class aClass = (Class)type;
                resolvableType = ResolvableType.forClass((Class)aClass);
            } else {
                resolvableType = (ResolvableType)type;
            }
            ResolvableType replyResolvableType = resolvableType;
            replyType = ParameterizedTypeReference.forType((Type)replyResolvableType.getType());
        }
        CompletionStage replyFuture = StringUtils.hasText((String)queue) ? this.amqpTemplate.sendAndReceive(queue, amqpMessage) : (StringUtils.hasText((String)exchange) ? this.amqpTemplate.sendAndReceive(exchange, routingKey, amqpMessage) : this.amqpTemplate.sendAndReceive(amqpMessage));
        if (!this.returnMessage) {
            ParameterizedTypeReference replyTypeToUse = replyType;
            replyFuture = replyFuture.thenApply(reply -> this.buildReplyMessage((org.springframework.amqp.core.Message)reply, replyTypeToUse));
        }
        return this.isAsync() ? replyFuture : replyFuture.join();
    }

    private AbstractIntegrationMessageBuilder<?> buildReplyMessage(org.springframework.amqp.core.Message message, @Nullable ParameterizedTypeReference<?> replyType) {
        Object replyPayload = replyType != null ? ((SmartMessageConverter)this.messageConverter).fromMessage(message, replyType) : this.messageConverter.fromMessage(message);
        return this.getMessageBuilderFactory().withPayload(replyPayload).copyHeaders(this.headerMapper.toHeadersFromReply(message.getMessageProperties()));
    }
}

