/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.amqp.config.AmqpChannelFactoryBean;
import org.springframework.integration.config.xml.AbstractChannelParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AmqpChannelParser
extends AbstractChannelParser {
    protected BeanDefinitionBuilder buildBeanDefinition(Element element, ParserContext parserContext) {
        String[] referencesToPopulate;
        String[] valuesToPopulate;
        String connectionFactory;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AmqpChannelFactoryBean.class);
        String messageDriven = element.getAttribute("message-driven");
        if (StringUtils.hasText((String)messageDriven)) {
            builder.addConstructorArgValue((Object)messageDriven);
        }
        if (!StringUtils.hasText((String)(connectionFactory = element.getAttribute("connection-factory")))) {
            connectionFactory = "rabbitConnectionFactory";
        }
        builder.addPropertyReference("connectionFactory", connectionFactory);
        builder.addPropertyValue("pubSub", (Object)"publish-subscribe-channel".equals(element.getLocalName()));
        this.populateConsumersPerQueueIfAny(element, parserContext, builder);
        for (String attribute : valuesToPopulate = new String[]{"max-subscribers", "acknowledge-mode", "auto-startup", "channel-transacted", "template-channel-transacted", "concurrent-consumers", "encoding", "expose-listener-channel", "phase", "prefetch-count", "queue-name", "receive-timeout", "recovery-interval", "missing-queues-fatal", "shutdown-timeout", "tx-size", "default-delivery-mode", "extract-payload", "headers-last"}) {
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)attribute);
        }
        for (String attribute : referencesToPopulate = new String[]{"advice-chain", "amqp-admin", "error-handler", "exchange", "message-converter", "message-properties-converter", "task-executor", "transaction-attribute", "transaction-manager", "outbound-header-mapper", "inbound-header-mapper"}) {
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)attribute);
        }
        return builder;
    }

    private void populateConsumersPerQueueIfAny(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String consumersPerQueue = element.getAttribute("consumers-per-queue");
        if (StringUtils.hasText((String)consumersPerQueue)) {
            if (StringUtils.hasText((String)element.getAttribute("concurrent-consumers"))) {
                parserContext.getReaderContext().error("'consumers-per-queue' and 'concurrent-consumers' are mutually exclusive", (Object)element);
            }
            if (StringUtils.hasText((String)element.getAttribute("tx-size"))) {
                parserContext.getReaderContext().error("'tx-size' is not allowed with 'consumers-per-queue'", (Object)element);
            }
            if (StringUtils.hasText((String)element.getAttribute("receive-timeout"))) {
                parserContext.getReaderContext().error("'receive-timeout' is not allowed with 'consumers-per-queue'", (Object)element);
            }
            builder.addPropertyValue("consumersPerQueue", (Object)consumersPerQueue);
        }
    }
}

