/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter;

import java.io.Serializable;
import org.springframework.integration.adapter.RemoteMessageHandler;
import org.springframework.integration.core.Message;
import org.springframework.integration.core.MessageChannel;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.message.MessageBuilder;
import org.springframework.integration.message.MessageHandlingException;
import org.springframework.remoting.RemoteAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemotingOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private final RemoteMessageHandler handlerProxy;

    public AbstractRemotingOutboundGateway(String url) {
        this.handlerProxy = this.createHandlerProxy(url);
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.setOutputChannel(replyChannel);
    }

    protected abstract RemoteMessageHandler createHandlerProxy(String var1);

    public final Object handleRequestMessage(Message<?> message) {
        if (!(message.getPayload() instanceof Serializable)) {
            throw new MessageHandlingException(message, String.valueOf(((Object)((Object)this)).getClass().getName()) + " expects a Serializable payload type " + "but encountered [" + message.getPayload().getClass().getName() + "]");
        }
        Message requestMessage = MessageBuilder.fromMessage(message).build();
        try {
            return this.handlerProxy.handle(requestMessage);
        }
        catch (RemoteAccessException e) {
            throw new MessageHandlingException(message, "unable to handle message remotely", (Throwable)e);
        }
    }
}

