/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.ConfigurableHandlerInstantiator;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.MessageSourceResolvableSerializer;
import org.springframework.hateoas.mediatype.hal.CollectionModelMixin;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.mediatype.hal.HalEmbeddedBuilder;
import org.springframework.hateoas.mediatype.hal.HalLinkRelation;
import org.springframework.hateoas.mediatype.hal.LinkMixin;
import org.springframework.hateoas.mediatype.hal.RepresentationModelMixin;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.ReflectionUtils;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.Version;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.PropertyNamingStrategies;
import tools.jackson.databind.PropertyNamingStrategy;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.deser.std.ContainerDeserializerBase;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.module.SimpleModule;
import tools.jackson.databind.ser.jdk.MapSerializer;
import tools.jackson.databind.ser.std.StdContainerSerializer;
import tools.jackson.databind.ser.std.StdScalarSerializer;
import tools.jackson.databind.type.CollectionType;
import tools.jackson.databind.type.MapType;
import tools.jackson.databind.type.TypeFactory;

public class HalJacksonModule
extends SimpleModule {
    private static final long serialVersionUID = 7806951456457932384L;
    private static final Link CURIES_REQUIRED_DUE_TO_EMBEDS = Link.of("__rel__", "\u00af\\_(\u30c4)_/\u00af");
    private static final TypeFactory TYPE_FACTORY = TypeFactory.createDefaultInstance();

    public HalJacksonModule() {
        super("json-hal-module", new Version(1, 0, 0, null, "org.springframework.hateoas", "spring-hateoas"));
        this.setMixInAnnotation(Link.class, LinkMixin.class);
        this.setMixInAnnotation(RepresentationModel.class, RepresentationModelMixin.class);
        this.setMixInAnnotation(CollectionModel.class, CollectionModelMixin.class);
    }

    public static boolean isAlreadyRegisteredIn(JsonMapper mapper) {
        Assert.notNull((Object)mapper, (String)"JsonMapper must not be null!");
        return LinkMixin.class.equals((Object)mapper.serializationConfig().findMixInClassFor(Link.class));
    }

    static class HalLink {
        private final Link link;
        private final @Nullable String title;

        public HalLink(Link link, @Nullable String title) {
            this.link = link;
            this.title = title;
        }

        @JsonUnwrapped
        public Link getLink() {
            return this.link;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty
        public @Nullable String getTitle() {
            return this.title;
        }
    }

    public static class EmbeddedMapper {
        private static final Function<String, String> NO_OP = Function.identity();
        private final LinkRelationProvider relProvider;
        private final CurieProvider curieProvider;
        private final boolean preferCollectionRels;
        private Function<String, String> relationTransformer = Function.identity();

        public EmbeddedMapper(LinkRelationProvider relProvider, CurieProvider curieProvider, boolean preferCollectionRels) {
            Assert.notNull((Object)relProvider, (String)"relProvider must not be null!");
            this.relProvider = relProvider;
            this.curieProvider = curieProvider;
            this.preferCollectionRels = preferCollectionRels;
        }

        private EmbeddedMapper(LinkRelationProvider relProvider, CurieProvider curieProvider, boolean preferCollectionRels, Function<String, String> relationTransformer) {
            Assert.notNull((Object)relProvider, (String)"relProvider must not be null!");
            this.relProvider = relProvider;
            this.curieProvider = curieProvider;
            this.preferCollectionRels = preferCollectionRels;
            this.relationTransformer = relationTransformer;
        }

        public EmbeddedMapper with(@Nullable PropertyNamingStrategy strategy) {
            Function<String, String> mapper = PropertyNamingStrategies.NamingBase.class.isInstance(strategy) ? it -> Translator.translate(it, strategy) : Function.identity();
            return mapper == null ? this : new EmbeddedMapper(this.relProvider, this.curieProvider, this.preferCollectionRels, mapper);
        }

        public Map<HalLinkRelation, Object> map(Iterable<?> source) {
            Assert.notNull(source, (String)"Elements must not be null!");
            HalEmbeddedBuilder builder = new HalEmbeddedBuilder(this.relProvider, this.curieProvider, this.preferCollectionRels).withRelationTransformer(this.relationTransformer);
            source.forEach(builder::add);
            return builder.asMap();
        }

        public HalLinkRelation map(LinkRelation source) {
            Assert.notNull((Object)source, (String)"Link relation must not be null!");
            return HalLinkRelation.of(this.relationTransformer == NO_OP ? source : source.map(this.relationTransformer));
        }

        public boolean hasCuriedEmbed(Iterable<?> source) {
            return this.map(source).keySet().stream().anyMatch(HalLinkRelation::isCuried);
        }

        private static class Translator {
            private static final Method METHOD = Objects.requireNonNull(ReflectionUtils.findMethod(PropertyNamingStrategies.NamingBase.class, (String)"translate", (Class[])new Class[]{String.class}));

            private Translator() {
            }

            static String translate(String source, PropertyNamingStrategy strategy) {
                if (!PropertyNamingStrategies.NamingBase.class.isInstance(strategy)) {
                    return source;
                }
                try {
                    Object result = METHOD.invoke((Object)strategy, source);
                    return (String)Objects.requireNonNull(result);
                }
                catch (Exception o_O) {
                    throw new RuntimeException(o_O);
                }
            }

            static {
                ReflectionUtils.makeAccessible((Method)METHOD);
            }
        }
    }

    public static class TrueOnlyBooleanSerializer
    extends StdScalarSerializer<Boolean> {
        public TrueOnlyBooleanSerializer() {
            super(Boolean.class);
        }

        public boolean isEmpty(SerializationContext provider, Boolean value) {
            return value == null || Boolean.FALSE.equals(value);
        }

        public void serialize(Boolean value, JsonGenerator jgen, SerializationContext provider) {
            jgen.writeBoolean(value.booleanValue());
        }

        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            if (visitor != null) {
                visitor.expectBooleanFormat(typeHint);
            }
        }
    }

    public static class HalHandlerInstantiator
    extends ConfigurableHandlerInstantiator {
        public HalHandlerInstantiator(LinkRelationProvider provider, CurieProvider curieProvider, MessageResolver resolver) {
            this(provider, curieProvider, resolver, new HalConfiguration(), (AutowireCapableBeanFactory)new DefaultListableBeanFactory());
        }

        public HalHandlerInstantiator(LinkRelationProvider provider, CurieProvider curieProvider, MessageResolver resolver, HalConfiguration halConfiguration, AutowireCapableBeanFactory delegate) {
            super(delegate);
            Assert.notNull((Object)provider, (String)"RelProvider must not be null!");
            Assert.notNull((Object)curieProvider, (String)"CurieProvider must not be null!");
            EmbeddedMapper mapper = new EmbeddedMapper(provider, curieProvider, halConfiguration.isEnforceEmbeddedCollections());
            this.registerInstance((Object)new HalResourcesSerializer(mapper, halConfiguration));
            this.registerInstance((Object)new HalLinkListSerializer(curieProvider, mapper, resolver, halConfiguration));
            this.registerInstance((Object)new MessageSourceResolvableSerializer(resolver));
        }
    }

    public static class HalResourcesDeserializer
    extends ContainerDeserializerBase<List<Object>> {
        private @Nullable JavaType contentType;

        public HalResourcesDeserializer() {
            this((JavaType)TYPE_FACTORY.constructCollectionLikeType(List.class, Object.class), null);
        }

        public HalResourcesDeserializer(JavaType vc) {
            this((JavaType)TYPE_FACTORY.constructCollectionLikeType(List.class, vc), vc);
        }

        private HalResourcesDeserializer(JavaType type, @Nullable JavaType contentType) {
            super(type);
            this.contentType = contentType;
        }

        public @Nullable ValueDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public List<Object> deserialize(JsonParser jp, DeserializationContext ctxt) {
            ArrayList<Object> result = new ArrayList<Object>();
            ValueDeserializer deser = ctxt.findRootValueDeserializer(this.contentType);
            while (!JsonToken.END_OBJECT.equals((Object)jp.nextToken())) {
                Object object;
                if (!JsonToken.PROPERTY_NAME.equals((Object)jp.currentToken())) {
                    throw new StreamReadException(jp, "Expected relation name");
                }
                if (JsonToken.START_ARRAY.equals((Object)jp.nextToken())) {
                    while (!JsonToken.END_ARRAY.equals((Object)jp.nextToken())) {
                        object = deser.deserialize(jp, ctxt);
                        result.add(object);
                    }
                    continue;
                }
                object = deser.deserialize(jp, ctxt);
                result.add(object);
            }
            return result;
        }

        public ValueDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) {
            JavaType type = property.getType().getContentType();
            return new HalResourcesDeserializer(type);
        }
    }

    public static class HalLinkListDeserializer
    extends ContainerDeserializerBase<List<Link>> {
        public HalLinkListDeserializer() {
            super((JavaType)TYPE_FACTORY.constructCollectionLikeType(List.class, Link.class));
        }

        public @Nullable ValueDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public List<Link> deserialize(JsonParser jp, DeserializationContext ctxt) {
            ArrayList<Link> result = new ArrayList<Link>();
            while (!JsonToken.END_OBJECT.equals((Object)jp.nextToken())) {
                if (!JsonToken.PROPERTY_NAME.equals((Object)jp.currentToken())) {
                    throw new StreamReadException(jp, "Expected relation name");
                }
                String relation = jp.getString();
                if (JsonToken.START_ARRAY.equals((Object)jp.nextToken())) {
                    while (!JsonToken.END_ARRAY.equals((Object)jp.nextToken())) {
                        result.add(((Link)jp.readValueAs(Link.class)).withRel(relation));
                    }
                    continue;
                }
                result.add(((Link)jp.readValueAs(Link.class)).withRel(relation));
            }
            return result;
        }
    }

    public static class OptionalListJackson2Serializer
    extends StdContainerSerializer<Object> {
        private final @Nullable BeanProperty property;
        private final Map<Class<?>, ValueSerializer<Object>> serializers;
        private final HalConfiguration halConfiguration;

        public OptionalListJackson2Serializer(@Nullable BeanProperty property, HalConfiguration halConfiguration) {
            super(List.class);
            this.property = property;
            this.serializers = new HashMap();
            this.halConfiguration = halConfiguration;
        }

        public StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void serialize(Object value, JsonGenerator jgen, SerializationContext provider) {
            List list = (List)value;
            if (list.isEmpty()) {
                return;
            }
            Object firstElement = list.get(0);
            if (!HalLink.class.isInstance(firstElement)) {
                this.serializeContents(list, jgen, provider);
                return;
            }
            HalLink halLink = (HalLink)firstElement;
            if (list.size() == 1 && this.halConfiguration.getSingleLinkRenderModeFor(halLink.getLink().getRel()).equals((Object)HalConfiguration.RenderSingleLinks.AS_SINGLE)) {
                this.serializeContents(halLink, jgen, provider);
                return;
            }
            this.serializeContents(list, jgen, provider);
        }

        public @Nullable ValueSerializer<?> getContentSerializer() {
            return null;
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public boolean hasSingleElement(Object arg0) {
            return false;
        }

        public boolean isEmpty(SerializationContext provider, Object value) {
            return false;
        }

        public ValueSerializer<?> createContextual(SerializationContext provider, BeanProperty property) {
            return new OptionalListJackson2Serializer(property, this.halConfiguration);
        }

        private void serializeContents(Object value, JsonGenerator jgen, SerializationContext provider) {
            this.getOrLookupSerializerFor(value, provider).serialize(value, jgen, provider);
        }

        private ValueSerializer<Object> getOrLookupSerializerFor(Object value, SerializationContext context) {
            Class<?> type = value.getClass();
            ValueSerializer serializer = this.serializers.get(type);
            if (serializer == null) {
                serializer = context.findPrimaryPropertySerializer(type, this.property);
                this.serializers.put(type, (ValueSerializer<Object>)serializer);
            }
            return serializer;
        }
    }

    public static class HalResourcesSerializer
    extends StdContainerSerializer<Collection<?>> {
        private final EmbeddedMapper embeddedMapper;
        private final HalConfiguration configuration;
        private final @Nullable BeanProperty property;

        public HalResourcesSerializer(EmbeddedMapper embeddedMapper, HalConfiguration configuration) {
            this(embeddedMapper, configuration, null);
        }

        public HalResourcesSerializer(EmbeddedMapper embeddedMapper, HalConfiguration configuration, @Nullable BeanProperty property) {
            super(Collection.class);
            this.embeddedMapper = embeddedMapper;
            this.configuration = configuration;
            this.property = property;
        }

        public void serialize(Collection<?> value, JsonGenerator jgen, SerializationContext provider) {
            EmbeddedMapper mapper = this.configuration.isApplyPropertyNamingStrategy() ? this.embeddedMapper.with(provider.getConfig().getPropertyNamingStrategy()) : this.embeddedMapper;
            Map<HalLinkRelation, Object> embeddeds = mapper.map(value);
            Object currentValue = jgen.currentValue();
            if (currentValue instanceof RepresentationModel && mapper.hasCuriedEmbed(value)) {
                ((RepresentationModel)currentValue).add(CURIES_REQUIRED_DUE_TO_EMBEDS);
            }
            LinkedHashMap map = new LinkedHashMap(embeddeds.size());
            embeddeds.forEach((key, it) -> map.put(key.value(), it));
            provider.findPrimaryPropertySerializer(Map.class, this.property).serialize(map, jgen, provider);
        }

        public ValueSerializer<?> createContextual(SerializationContext prov, BeanProperty property) {
            return new HalResourcesSerializer(this.embeddedMapper, this.configuration, property);
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable ValueSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(SerializationContext provider, Collection<?> value) {
            return value.isEmpty();
        }

        public boolean hasSingleElement(Collection<?> value) {
            return value.size() == 1;
        }

        protected @Nullable StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }

    public static class HalLinkListSerializer
    extends StdContainerSerializer<Links> {
        private final @Nullable BeanProperty property;
        private final CurieProvider curieProvider;
        private final EmbeddedMapper mapper;
        private final MessageResolver resolver;
        private final HalConfiguration halConfiguration;

        public HalLinkListSerializer(CurieProvider curieProvider, EmbeddedMapper mapper, MessageResolver resolver, HalConfiguration halConfiguration) {
            this(null, curieProvider, mapper, resolver, halConfiguration);
        }

        public HalLinkListSerializer(@Nullable BeanProperty property, CurieProvider curieProvider, EmbeddedMapper mapper, MessageResolver resolver, HalConfiguration halConfiguration) {
            super(Links.class);
            Assert.notNull((Object)curieProvider, (String)"CurieProvider must not be null!");
            Assert.notNull((Object)mapper, (String)"EmbeddedMapper must not be null!");
            Assert.notNull((Object)resolver, (String)"MessageResolver must not be null!");
            Assert.notNull((Object)halConfiguration, (String)"HalConfiguration must not be null!");
            this.property = property;
            this.curieProvider = curieProvider;
            this.mapper = mapper;
            this.resolver = resolver;
            this.halConfiguration = halConfiguration;
        }

        public void serialize(Links value, JsonGenerator jgen, SerializationContext provider) {
            Collection<?> curies;
            EmbeddedMapper transformingMapper;
            LinkedMultiValueMap sortedLinks = new LinkedMultiValueMap();
            ArrayList<Link> links = new ArrayList<Link>();
            boolean prefixingRequired = this.curieProvider != CurieProvider.NONE;
            boolean curiedLinkPresent = false;
            boolean skipCuries = !jgen.streamWriteContext().getParent().inRoot();
            Object currentValue = jgen.currentValue();
            PropertyNamingStrategy propertyNamingStrategy = provider.getConfig().getPropertyNamingStrategy();
            EmbeddedMapper embeddedMapper = transformingMapper = this.halConfiguration.isApplyPropertyNamingStrategy() ? this.mapper.with(propertyNamingStrategy) : this.mapper;
            if (currentValue instanceof CollectionModel && transformingMapper.hasCuriedEmbed((CollectionModel)currentValue)) {
                curiedLinkPresent = true;
            }
            for (Link link : value) {
                if (link.equals(CURIES_REQUIRED_DUE_TO_EMBEDS)) continue;
                LinkRelation rel = prefixingRequired ? this.curieProvider.getNamespacedRelFrom(link) : link.getRel();
                HalLinkRelation relation = transformingMapper.map(rel);
                if (relation.isCuried()) {
                    curiedLinkPresent = true;
                }
                sortedLinks.add((Object)relation.value(), (Object)this.toHalLink(link, relation));
                links.add(link);
            }
            if (!skipCuries && prefixingRequired && curiedLinkPresent && !(curies = this.curieProvider.getCurieInformation(Links.of(links))).isEmpty()) {
                sortedLinks.addAll((Object)HalLinkRelation.CURIES.value(), new ArrayList(curies));
            }
            TypeFactory typeFactory = provider.getConfig().getTypeFactory();
            JavaType keyType = typeFactory.constructType(String.class);
            CollectionType valueType = typeFactory.constructCollectionType(ArrayList.class, Object.class);
            MapType mapType = typeFactory.constructMapType(HashMap.class, keyType, (JavaType)valueType);
            MapSerializer serializer = MapSerializer.construct((JavaType)mapType, (boolean)true, null, (ValueSerializer)provider.findKeySerializer(keyType, null), (ValueSerializer)new OptionalListJackson2Serializer(this.property, this.halConfiguration), null, Collections.emptySet(), null);
            serializer.serialize((Map)sortedLinks, jgen, provider);
        }

        private HalLink toHalLink(Link link, HalLinkRelation rel) {
            return new HalLink(link, this.resolver.resolve(rel));
        }

        public ValueSerializer<?> createContextual(SerializationContext provider, BeanProperty property) {
            return new HalLinkListSerializer(property, this.curieProvider, this.mapper, this.resolver, this.halConfiguration);
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable ValueSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(SerializationContext provider, Links value) {
            return value == null || value.isEmpty();
        }

        public boolean hasSingleElement(Links value) {
            return value.toList().size() == 1;
        }

        protected @Nullable StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }
}

