/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.mvc;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.JacksonJsonHttpMessageConverter;
import org.springframework.util.Assert;
import tools.jackson.databind.json.JsonMapper;

public class TypeConstrainedJacksonJsonHttpMessageConverter
extends JacksonJsonHttpMessageConverter {
    private final Class<?> type;

    public TypeConstrainedJacksonJsonHttpMessageConverter(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        this.type = type;
    }

    public TypeConstrainedJacksonJsonHttpMessageConverter(Class<?> type, List<MediaType> supportedMediaTypes, JsonMapper mapper) {
        super(mapper);
        this.setSupportedMediaTypes(supportedMediaTypes);
        this.type = type;
    }

    public boolean canRead(Class<?> clazz, @Nullable MediaType mediaType) {
        return this.type.isAssignableFrom(clazz) && super.canRead(clazz, mediaType);
    }

    public boolean canRead(ResolvableType type, @Nullable MediaType mediaType) {
        return this.type.isAssignableFrom(this.getJavaType(type.getType(), null).getRawClass()) && super.canRead(type, mediaType);
    }

    public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
        return this.type.isAssignableFrom(clazz) && super.canWrite(clazz, mediaType);
    }
}

