/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import java.util.Map;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.client.JsonPathLinkDiscoverer;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;

public class HalLinkDiscoverer
extends JsonPathLinkDiscoverer {
    private static final String PATH = "_links..['%s']";
    private static final String JSON_PATH = "$._links..['%s']";
    private static final String RECURSIVE_JSON_PATH = "$.._links..['%s']";

    public HalLinkDiscoverer() {
        this(MediaTypes.HAL_JSON, MediaTypes.VND_HAL_JSON);
    }

    protected HalLinkDiscoverer(MediaType ... mediaTypes) {
        super(JSON_PATH, mediaTypes);
    }

    public LinkDiscoverer inspectEmbeddeds() {
        return new JsonPathLinkDiscoverer(RECURSIVE_JSON_PATH, (MediaType[])this.mediaTypes.toArray(MediaType[]::new)){

            @Override
            protected Link extractLink(Object element, LinkRelation rel) {
                return HalLinkDiscoverer.this.extractLink(element, rel);
            }
        };
    }

    @Override
    protected Link extractLink(Object element, LinkRelation rel) {
        if (!Map.class.isInstance(element)) {
            return super.extractLink(element, rel);
        }
        Map json = (Map)element;
        String href = (String)json.get("href");
        Assert.state((href != null ? 1 : 0) != 0, (String)"No href found in link data!");
        return Link.of(href, rel).withHreflang((String)json.get("hreflang")).withMedia((String)json.get("media")).withTitle((String)json.get("title")).withType((String)json.get("type")).withDeprecation((String)json.get("deprecation")).withProfile((String)json.get("profile")).withName((String)json.get("name"));
    }
}

