/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.core.EmbeddedWrapper;
import org.springframework.util.Assert;

public class EmbeddedWrappers {
    private static ResolvableType SUPPLIER_OF_STREAM = ResolvableType.forClassWithGenerics(Supplier.class, (Class[])new Class[]{Stream.class});
    private final boolean preferCollections;

    public EmbeddedWrappers(boolean preferCollections) {
        this.preferCollections = preferCollections;
    }

    public EmbeddedWrapper wrap(Object source) {
        return this.wrap(source, AbstractEmbeddedWrapper.NO_REL);
    }

    public EmbeddedWrapper emptyCollectionOf(Class<?> type) {
        return new EmptyCollectionEmbeddedWrapper(type);
    }

    public EmbeddedWrapper wrap(Object source, LinkRelation rel) {
        Assert.notNull((Object)source, (String)"Source must not be null!");
        Assert.notNull((Object)rel, (String)"Link relation must not be null!");
        if (source instanceof EmbeddedWrapper) {
            return (EmbeddedWrapper)source;
        }
        return source instanceof Collection || source instanceof Stream || this.preferCollections || SUPPLIER_OF_STREAM.isAssignableFrom(source.getClass()) ? new EmbeddedCollection(EmbeddedWrappers.asCollection(source), rel) : new EmbeddedElement(source, rel);
    }

    private static Collection<Object> asCollection(@Nullable Object source) {
        if (source == null) {
            return Collections.emptyList();
        }
        if (Collection.class.isInstance(source)) {
            return (Collection)Collection.class.cast(source);
        }
        if (Stream.class.isInstance(source)) {
            return ((Stream)Stream.class.cast(source)).collect(Collectors.toList());
        }
        if (source.getClass().isArray()) {
            return Arrays.asList((Object[])source);
        }
        if (SUPPLIER_OF_STREAM.isInstance(source)) {
            return EmbeddedWrappers.asCollection(((Supplier)source).get());
        }
        return Collections.singleton(source);
    }

    private static abstract class AbstractEmbeddedWrapper
    implements EmbeddedWrapper {
        private static final LinkRelation NO_REL = LinkRelation.of("___norel___");
        private final LinkRelation rel;

        public AbstractEmbeddedWrapper(LinkRelation rel) {
            Assert.notNull((Object)rel, (String)"Rel must not be null or empty!");
            this.rel = rel;
        }

        @Override
        public Optional<LinkRelation> getRel() {
            return Optional.ofNullable(this.rel).filter(it -> !it.equals(NO_REL));
        }

        @Override
        public boolean hasRel(LinkRelation rel) {
            return this.rel.isSameAs(rel);
        }

        @Override
        public @Nullable Class<?> getRelTargetType() {
            Object peek = this.peek();
            Object object = peek = peek instanceof EntityModel ? ((EntityModel)peek).getContent() : peek;
            if (peek == null) {
                return null;
            }
            return AopUtils.getTargetClass((Object)peek);
        }

        protected abstract @Nullable Object peek();
    }

    private static class EmptyCollectionEmbeddedWrapper
    implements EmbeddedWrapper {
        private final Class<?> type;

        public EmptyCollectionEmbeddedWrapper(Class<?> type) {
            Assert.notNull(type, (String)"Element type must not be null!");
            this.type = type;
        }

        @Override
        public Optional<LinkRelation> getRel() {
            return Optional.empty();
        }

        @Override
        public Object getValue() {
            return Collections.emptySet();
        }

        @Override
        public @NonNull Class<?> getRelTargetType() {
            return this.type;
        }

        @Override
        public boolean isCollectionValue() {
            return true;
        }

        @Override
        public boolean hasRel(LinkRelation rel) {
            return false;
        }
    }

    private static class EmbeddedCollection
    extends AbstractEmbeddedWrapper {
        private final Collection<Object> value;

        public EmbeddedCollection(Collection<Object> value, LinkRelation rel) {
            super(rel);
            Assert.notNull(value, (String)"Collection must not be null!");
            if (AbstractEmbeddedWrapper.NO_REL.equals(rel) && value.isEmpty()) {
                throw new IllegalArgumentException("Cannot wrap an empty collection with no rel given!");
            }
            this.value = value;
        }

        @Override
        public Collection<Object> getValue() {
            return this.value;
        }

        @Override
        protected @Nullable Object peek() {
            return this.value.isEmpty() ? null : this.value.iterator().next();
        }

        @Override
        public boolean isCollectionValue() {
            return true;
        }
    }

    private static class EmbeddedElement
    extends AbstractEmbeddedWrapper {
        private final Object value;

        public EmbeddedElement(Object value, LinkRelation relation) {
            super(relation);
            Assert.notNull((Object)value, (String)"Value must not be null!");
            this.value = value;
        }

        @Override
        public @NonNull Object getValue() {
            return this.value;
        }

        @Override
        protected @NonNull Object peek() {
            return this.getValue();
        }

        @Override
        public boolean isCollectionValue() {
            return false;
        }
    }
}

