/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.mapper.MappingException;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import org.jspecify.annotations.Nullable;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.json.JsonMapper;

public class JacksonMappingProvider
implements MappingProvider {
    private static final JsonMapper DEFAULT_MAPPER = new JsonMapper();
    private final JsonMapper mapper;

    public JacksonMappingProvider() {
        this(DEFAULT_MAPPER);
    }

    public JacksonMappingProvider(JsonMapper mapper) {
        this.mapper = mapper;
    }

    public <T> @Nullable T map(Object source, Class<T> targetType, Configuration configuration) {
        if (source == null) {
            return null;
        }
        try {
            return (T)this.mapper.convertValue(source, targetType);
        }
        catch (Exception e) {
            throw new MappingException((Throwable)e);
        }
    }

    public <T> @Nullable T map(Object source, TypeRef<T> targetType, Configuration configuration) {
        if (source == null) {
            return null;
        }
        JavaType type = this.mapper.getTypeFactory().constructType(targetType.getType());
        try {
            return (T)this.mapper.convertValue(source, type);
        }
        catch (Exception e) {
            throw new MappingException((Throwable)e);
        }
    }
}

