/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class LinkParser {
    LinkParser() {
    }

    public static List<Link> parseLinks(String source) {
        ArrayList<Link> links = new ArrayList<Link>();
        int l = source.length();
        int[] pos = new int[]{0};
        boolean inLink = true;
        while (pos[0] < l) {
            char ch = source.charAt(pos[0]);
            if (Character.isWhitespace(ch)) {
                pos[0] = pos[0] + 1;
                continue;
            }
            if (inLink) {
                if (ch == '<') {
                    Link link = LinkParser.parseLink(source, pos);
                    String[] rels = link.getRel().value().split("\\s");
                    if (rels.length == 0) {
                        throw new IllegalArgumentException("A link with missing rel at " + pos[0]);
                    }
                    for (String rel : rels) {
                        links.add(link.withRel(rel));
                    }
                    inLink = false;
                    continue;
                }
                if (ch == ',') {
                    pos[0] = pos[0] + 1;
                    continue;
                }
            } else if (ch == ',') {
                pos[0] = pos[0] + 1;
                inLink = true;
                continue;
            }
            throw new IllegalArgumentException("Unexpected data at the end of Link header at index " + pos[0]);
        }
        return links;
    }

    public static Link parseLink(String input) {
        return LinkParser.parseLink(input, new int[]{0});
    }

    /*
     * Enabled aggressive block sorting
     */
    static Link parseLink(String input, int[] pos) {
        String sRel;
        Assert.notNull((Object)input, (String)"Input string must not be null!");
        Assert.isTrue((pos.length == 1 ? 1 : 0) != 0, (String)"Array length must be one!");
        int l = input.length();
        while (pos[0] < l && Character.isWhitespace(input.charAt(pos[0]))) {
            pos[0] = pos[0] + 1;
        }
        if (input.charAt(pos[0]) != '<') {
            throw new IllegalArgumentException("Expecting '<' at index " + pos[0]);
        }
        pos[0] = pos[0] + 1;
        int urlEnd = input.indexOf(62, pos[0]);
        if (urlEnd < 0) {
            throw new IllegalArgumentException("Missing closing '>' at index " + input.length());
        }
        String url = input.substring(pos[0], urlEnd);
        pos[0] = urlEnd + 1;
        HashMap<String, String> params = new HashMap<String, String>();
        State state = State.INITIAL;
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        block7: while (pos[0] <= l) {
            boolean eoi = pos[0] == l;
            char ch = eoi ? (char)'\u0000' : input.charAt(pos[0]);
            switch (state) {
                case INITIAL: {
                    if (Character.isWhitespace(ch)) {
                        pos[0] = pos[0] + 1;
                        break;
                    }
                    if (ch != ';') break block7;
                    state = State.IN_KEY;
                    pos[0] = pos[0] + 1;
                    break;
                }
                case IN_KEY: {
                    if (ch == '=') {
                        state = State.BEFORE_VALUE;
                    } else if (ch == ';' || ch == ',' || eoi) {
                        if (!key.isEmpty()) {
                            params.put(key.toString().trim(), "");
                            key.setLength(0);
                        }
                    } else {
                        key.append(ch);
                    }
                    pos[0] = pos[0] + 1;
                    break;
                }
                case BEFORE_VALUE: {
                    if (Character.isWhitespace(ch)) {
                        pos[0] = pos[0] + 1;
                        break;
                    }
                    if (ch == '\"' || ch == '\'') {
                        LinkParser.consumeQuotedString(input, value, pos);
                        params.putIfAbsent(key.toString().trim(), value.toString());
                        key.setLength(0);
                        value.setLength(0);
                        state = State.INITIAL;
                        break;
                    }
                    state = State.IN_VALUE;
                    break;
                }
                case IN_VALUE: {
                    if (ch == ';' || ch == ',' || eoi) {
                        params.putIfAbsent(key.toString().trim(), value.toString().trim());
                        key.setLength(0);
                        value.setLength(0);
                        state = State.INITIAL;
                        break;
                    }
                    value.append(ch);
                    pos[0] = pos[0] + 1;
                }
            }
        }
        if (!StringUtils.hasText((String)(sRel = (String)params.get("rel")))) {
            throw new IllegalArgumentException("Missing 'rel' attribute at index " + pos[0]);
        }
        LinkRelation rel = LinkRelation.of(sRel);
        String hrefLang = (String)params.get("hreflang");
        String media = (String)params.get("media");
        String title = (String)params.get("title");
        String type = (String)params.get("type");
        String deprecation = (String)params.get("deprecation");
        String profile = (String)params.get("profile");
        String name = (String)params.get("name");
        return new Link(rel, url, hrefLang, media, title, type, deprecation, profile, name, Link.templateOrNull(url), Collections.emptyList());
    }

    private static void consumeQuotedString(String input, StringBuilder target, int[] pos) {
        int l = input.length();
        char quotingChar = input.charAt(pos[0]);
        Assert.isTrue((quotingChar == '\"' || quotingChar == '\'' ? 1 : 0) != 0, (String)"Expected to find a quoting character (' or \")!");
        pos[0] = pos[0] + 1;
        while (pos[0] < l) {
            char ch = input.charAt(pos[0]);
            if (ch == quotingChar) {
                pos[0] = pos[0] + 1;
                return;
            }
            if (ch == '\\') {
                pos[0] = pos[0] + 1;
                ch = input.charAt(pos[0]);
            }
            target.append(ch);
            pos[0] = pos[0] + 1;
        }
        throw new IllegalArgumentException("Missing final quote at index " + pos[0]);
    }

    private static enum State {
        INITIAL,
        IN_KEY,
        BEFORE_VALUE,
        IN_VALUE;

    }
}

