/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.QueryParameter;
import org.springframework.hateoas.mediatype.Affordances;
import org.springframework.hateoas.server.core.AnnotationMappingDiscoverer;
import org.springframework.hateoas.server.core.CachingMappingDiscoverer;
import org.springframework.hateoas.server.core.MappingDiscoverer;
import org.springframework.hateoas.server.core.MethodParameters;
import org.springframework.hateoas.server.core.PropertyResolvingMappingDiscoverer;
import org.springframework.hateoas.server.core.UriMapping;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentLruCache;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public class SpringAffordanceBuilder {
    public static final MappingDiscoverer DISCOVERER = CachingMappingDiscoverer.of(new PropertyResolvingMappingDiscoverer(new AnnotationMappingDiscoverer(RequestMapping.class)));
    private static final ConcurrentLruCache<AffordanceKey, Function<Affordances, List<Affordance>>> AFFORDANCES_CACHE = new ConcurrentLruCache(256, key -> SpringAffordanceBuilder.create(key.type, key.method));

    public static List<Affordance> getAffordances(Class<?> type, Method method, String href) {
        String methodName = method.getName();
        Link affordanceLink = Link.of(href, LinkRelation.of(methodName));
        return (List)((Function)AFFORDANCES_CACHE.get((Object)new AffordanceKey(type, method))).apply(Affordances.of(affordanceLink));
    }

    @Nullable
    @Deprecated
    public static String getMapping(Class<?> type, Method method) {
        return DISCOVERER.getMapping(type, method);
    }

    public static UriMapping getUriMapping(Class<?> type, Method method) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.notNull((Object)method, (String)"Method must not be null!");
        UriMapping mapping = DISCOVERER.getUriMapping(type, method);
        if (mapping == null) {
            throw new IllegalArgumentException("No mapping found for %s!".formatted(method.toString()));
        }
        return mapping;
    }

    private static Function<Affordances, List<Affordance>> create(Class<?> type, Method method) {
        String methodName = method.getName();
        ResolvableType outputType = ResolvableType.forMethodReturnType((Method)method);
        Collection<HttpMethod> requestMethods = DISCOVERER.getRequestMethod(type, method);
        List<MediaType> inputMediaTypes = DISCOVERER.getConsumes(method);
        MethodParameters parameters = MethodParameters.of(method);
        ResolvableType inputType = parameters.getParametersWith(RequestBody.class).stream().findFirst().map(ResolvableType::forMethodParameter).orElse(ResolvableType.NONE);
        List queryMethodParameters = parameters.getParametersWith(RequestParam.class).stream().filter(it -> !Map.class.isAssignableFrom(it.getParameterType())).map(QueryParameter::of).collect(Collectors.toList());
        return affordances -> requestMethods.stream().flatMap(it -> affordances.afford((HttpMethod)it).withInput(inputType).withOutput(outputType).withParameters(queryMethodParameters).withName(methodName).withInputMediaTypes(inputMediaTypes).build().stream()).collect(Collectors.toList());
    }

    private static final class AffordanceKey {
        private final Class<?> type;
        private final Method method;

        AffordanceKey(Class<?> type, Method method) {
            this.type = type;
            this.method = method;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AffordanceKey)) {
                return false;
            }
            AffordanceKey that = (AffordanceKey)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.method, that.method);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.method);
        }

        public String toString() {
            return "WebHandler.AffordanceKey(type=" + this.type + ", method=" + this.method + ")";
        }
    }
}

