/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.collectionjson;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.mediatype.ConfiguredAffordance;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonData;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;

class CollectionJsonAffordanceModel
extends AffordanceModel {
    private static final Set<HttpMethod> ENTITY_ALTERING_METHODS = EnumSet.of(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH);
    private final List<CollectionJsonData> inputProperties = this.determineInputs();
    private final List<CollectionJsonData> queryProperties = this.determineQueryProperties();

    CollectionJsonAffordanceModel(ConfiguredAffordance configured) {
        super(configured.getNameOrDefault(), configured.getTarget(), configured.getMethod(), configured.getInputMetadata(), configured.getQueryParameters(), configured.getOutputMetadata());
    }

    private List<CollectionJsonData> determineInputs() {
        if (!ENTITY_ALTERING_METHODS.contains(this.getHttpMethod())) {
            return Collections.emptyList();
        }
        return this.getInput().stream().map(AffordanceModel.PropertyMetadata::getName).map(propertyName -> new CollectionJsonData().withName((String)propertyName).withValue("")).collect(Collectors.toList());
    }

    private List<CollectionJsonData> determineQueryProperties() {
        if (!this.getHttpMethod().equals((Object)HttpMethod.GET)) {
            return Collections.emptyList();
        }
        return this.getQueryMethodParameters().stream().map(queryProperty -> new CollectionJsonData().withName(queryProperty.getName()).withValue("")).collect(Collectors.toList());
    }

    public List<CollectionJsonData> getInputProperties() {
        return this.inputProperties;
    }

    public List<CollectionJsonData> getQueryProperties() {
        return this.queryProperties;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CollectionJsonAffordanceModel)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CollectionJsonAffordanceModel that = (CollectionJsonAffordanceModel)o;
        return Objects.equals(this.inputProperties, that.inputProperties) && Objects.equals(this.queryProperties, that.queryProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inputProperties, this.queryProperties);
    }
}

