/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.mvc;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.server.core.DummyInvocationUtils;
import org.springframework.hateoas.server.core.TemplateVariableAwareLinkBuilderSupport;
import org.springframework.hateoas.server.core.UriTemplateFactory;
import org.springframework.hateoas.server.core.WebHandler;
import org.springframework.hateoas.server.mvc.UriComponentsBuilderFactory;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilderFactory;
import org.springframework.util.Assert;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class WebMvcLinkBuilder
extends TemplateVariableAwareLinkBuilderSupport<WebMvcLinkBuilder> {
    private static final WebMvcLinkBuilderFactory FACTORY = new WebMvcLinkBuilderFactory();
    private static final CustomUriTemplateHandler HANDLER = new CustomUriTemplateHandler();

    WebMvcLinkBuilder(UriComponents components) {
        this(components, TemplateVariables.NONE, Collections.emptyList());
    }

    WebMvcLinkBuilder(UriComponents uriComponents, TemplateVariables variables, List<Affordance> affordances) {
        super(uriComponents, variables, affordances);
    }

    public static WebMvcLinkBuilder linkTo(Class<?> controller) {
        return WebMvcLinkBuilder.linkTo(controller, new Object[0]);
    }

    public static WebMvcLinkBuilder linkTo(Class<?> controller, Object ... parameters) {
        Assert.notNull(controller, (String)"Controller must not be null!");
        Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
        String mapping = WebHandler.DISCOVERER.getMapping(controller);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)(mapping == null ? "/" : mapping));
        UriComponents uriComponents = HANDLER.expandAndEncode(builder, parameters);
        return (WebMvcLinkBuilder)new WebMvcLinkBuilder(UriComponentsBuilderFactory.getComponents()).slash(uriComponents, true);
    }

    public static WebMvcLinkBuilder linkTo(Class<?> controller, Map<String, ?> parameters) {
        Assert.notNull(controller, (String)"Controller must not be null!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        String mapping = WebHandler.DISCOVERER.getMapping(controller);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)(mapping == null ? "/" : mapping));
        UriComponents uriComponents = HANDLER.expandAndEncode(builder, parameters);
        return (WebMvcLinkBuilder)new WebMvcLinkBuilder(UriComponentsBuilderFactory.getComponents()).slash(uriComponents, true);
    }

    public static WebMvcLinkBuilder linkTo(Method method, Object ... parameters) {
        return WebMvcLinkBuilder.linkTo(method.getDeclaringClass(), method, parameters);
    }

    public static WebMvcLinkBuilder linkTo(Class<?> controller, Method method, Object ... parameters) {
        Assert.notNull(controller, (String)"Controller type must not be null!");
        Assert.notNull((Object)method, (String)"Method must not be null!");
        String mapping = WebHandler.DISCOVERER.getMapping(controller, method);
        UriTemplate template = UriTemplateFactory.templateFor(mapping);
        URI uri = template.expand(parameters);
        return (WebMvcLinkBuilder)new WebMvcLinkBuilder(UriComponentsBuilderFactory.getComponents()).slash(uri);
    }

    public static WebMvcLinkBuilder linkTo(Object invocationValue) {
        return FACTORY.linkTo(invocationValue);
    }

    public static Affordance afford(Object invocationValue) {
        WebMvcLinkBuilder linkBuilder = WebMvcLinkBuilder.linkTo(invocationValue);
        Assert.isTrue((linkBuilder.getAffordances().size() == 1 ? 1 : 0) != 0, (String)"A base can only have one affordance, itself");
        return linkBuilder.getAffordances().get(0);
    }

    public static <T> T methodOn(Class<T> controller, Object ... parameters) {
        return DummyInvocationUtils.methodOn(controller, parameters);
    }

    @Override
    protected WebMvcLinkBuilder getThis() {
        return this;
    }

    @Override
    protected WebMvcLinkBuilder createNewInstance(UriComponents components, List<Affordance> affordances, TemplateVariables variables) {
        return new WebMvcLinkBuilder(components, variables, affordances);
    }

    public UriComponentsBuilder toUriComponentsBuilder() {
        return UriComponentsBuilder.fromUri((URI)this.toUri());
    }

    private static class CustomUriTemplateHandler
    extends DefaultUriTemplateHandler {
        public CustomUriTemplateHandler() {
            this.setStrictEncoding(true);
        }

        public UriComponents expandAndEncode(UriComponentsBuilder builder, Map<String, ?> uriVariables) {
            return super.expandAndEncode(builder, uriVariables);
        }

        public UriComponents expandAndEncode(UriComponentsBuilder builder, Object[] uriVariables) {
            return super.expandAndEncode(builder, uriVariables);
        }
    }
}

