/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.QueryParameter;
import org.springframework.hateoas.mediatype.AffordanceModelFactory;
import org.springframework.hateoas.mediatype.AffordanceOperations;
import org.springframework.hateoas.mediatype.PropertyUtils;
import org.springframework.hateoas.mediatype.TypeBasedPayloadMetadata;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Affordances
implements AffordanceOperations {
    private static List<AffordanceModelFactory> factories = SpringFactoriesLoader.loadFactories(AffordanceModelFactory.class, (ClassLoader)Affordance.class.getClassLoader());
    private final Link link;

    public Stream<Affordance> stream() {
        return this.link.getAffordances().stream();
    }

    public AffordanceBuilder afford(HttpMethod httpMethod) {
        Assert.notNull((Object)httpMethod, (String)"HTTP method must not be null!");
        return new AffordanceBuilder(this, httpMethod, this.link, AffordanceModel.InputPayloadMetadata.NONE, AffordanceModel.PayloadMetadata.NONE, Collections.emptyList(), null);
    }

    @Override
    public Link toLink() {
        return this.link;
    }

    @Generated
    private Affordances(Link link) {
        this.link = link;
    }

    @NonNull
    @Generated
    public static Affordances of(Link link) {
        return new Affordances(link);
    }

    public static class AffordanceBuilder
    implements AffordanceOperations {
        private final Affordances context;
        private final HttpMethod method;
        private final Link target;
        private final AffordanceModel.InputPayloadMetadata inputMetdata;
        private final AffordanceModel.PayloadMetadata outputMetadata;
        private List<QueryParameter> parameters = Collections.emptyList();
        @Nullable
        private String name;

        public AffordanceBuilder withInputAndOutput(Class<?> type) {
            return this.withInput(type).withOutput(type);
        }

        public AffordanceBuilder withInputAndOutput(ResolvableType type) {
            return this.withInput(type).withOutput(type);
        }

        public AffordanceBuilder withInputAndOutput(AffordanceModel.PayloadMetadata metadata) {
            return this.withInput(metadata).withOutput(metadata);
        }

        public AffordanceBuilder withInput(Class<?> type) {
            Assert.notNull(type, (String)"Type must not be null!");
            return this.withInput(ResolvableType.forClass(type));
        }

        public AffordanceBuilder withInput(ResolvableType type) {
            Assert.notNull((Object)type, (String)"Type must not be null!");
            return this.withInput(PropertyUtils.getExposedProperties(type));
        }

        public AffordanceBuilder withInput(AffordanceModel.PayloadMetadata metadata) {
            AffordanceModel.InputPayloadMetadata inputMetadata = AffordanceModel.InputPayloadMetadata.from(metadata);
            return new AffordanceBuilder(this.context, this.method, this.target, inputMetadata, this.outputMetadata, this.parameters, this.name);
        }

        public AffordanceBuilder withOutput(Class<?> type) {
            return this.withOutput(ResolvableType.forClass(type));
        }

        public AffordanceBuilder withOutput(ResolvableType type) {
            return this.withOutput(PropertyUtils.getExposedProperties(type));
        }

        public AffordanceBuilder withOutput(AffordanceModel.PayloadMetadata metadata) {
            return new AffordanceBuilder(this.context, this.method, this.target, this.inputMetdata, metadata, this.parameters, this.name);
        }

        public AffordanceBuilder withParameters(QueryParameter ... parameters) {
            return this.withParameters(Arrays.asList(parameters));
        }

        public AffordanceBuilder withParameters(List<QueryParameter> parameters) {
            return new AffordanceBuilder(this.context, this.method, this.target, this.inputMetdata, this.outputMetadata, parameters, this.name);
        }

        public AffordanceBuilder addParameters(QueryParameter ... parameters) {
            ArrayList<QueryParameter> newParameters = new ArrayList<QueryParameter>(this.parameters.size() + parameters.length);
            newParameters.addAll(this.parameters);
            newParameters.addAll(Arrays.asList(parameters));
            return new AffordanceBuilder(this.context, this.method, this.target, this.inputMetdata, this.outputMetadata, newParameters, this.name);
        }

        public AffordanceBuilder andAfford(HttpMethod method) {
            return this.build().afford(method);
        }

        @Override
        public Link toLink() {
            return this.context.link.andAffordance(this.buildAffordance());
        }

        public Affordances build() {
            return Affordances.of(this.toLink());
        }

        private Affordance buildAffordance() {
            return factories.stream().collect(Collectors.collectingAndThen(Collectors.toMap(AffordanceModelFactory::getMediaType, it -> this.createModel((AffordanceModelFactory)it, (List<QueryParameter>)(this.parameters == null ? Collections.emptyList() : this.parameters))), Affordance::new));
        }

        private AffordanceModel createModel(AffordanceModelFactory factory, List<QueryParameter> parameters) {
            return factory.getAffordanceModel(this.getNameOrDefault(), this.target, this.method, this.inputMetdata, parameters, this.outputMetadata);
        }

        private String getNameOrDefault() {
            ResolvableType type;
            if (this.name != null) {
                return this.name;
            }
            String name = this.method.toString().toLowerCase();
            ResolvableType resolvableType = type = TypeBasedPayloadMetadata.class.isInstance(this.inputMetdata) ? ((TypeBasedPayloadMetadata)TypeBasedPayloadMetadata.class.cast(this.inputMetdata)).getType() : null;
            if (type == null) {
                return name;
            }
            Class resolvedType = type.resolve();
            return resolvedType == null ? name : name.concat(resolvedType.getSimpleName());
        }

        @Generated
        private AffordanceBuilder(Affordances context, HttpMethod method, Link target, AffordanceModel.InputPayloadMetadata inputMetdata, AffordanceModel.PayloadMetadata outputMetadata) {
            this.context = context;
            this.method = method;
            this.target = target;
            this.inputMetdata = inputMetdata;
            this.outputMetadata = outputMetadata;
        }

        @Generated
        private AffordanceBuilder(Affordances context, HttpMethod method, Link target, AffordanceModel.InputPayloadMetadata inputMetdata, AffordanceModel.PayloadMetadata outputMetadata, List<QueryParameter> parameters, @Nullable String name) {
            this.context = context;
            this.method = method;
            this.target = target;
            this.inputMetdata = inputMetdata;
            this.outputMetadata = outputMetadata;
            this.parameters = parameters;
            this.name = name;
        }

        @NonNull
        @Generated
        public AffordanceBuilder withTarget(Link target) {
            return this.target == target ? this : new AffordanceBuilder(this.context, this.method, target, this.inputMetdata, this.outputMetadata, this.parameters, this.name);
        }

        @NonNull
        @Generated
        public AffordanceBuilder withName(@Nullable String name) {
            return this.name == name ? this : new AffordanceBuilder(this.context, this.method, this.target, this.inputMetdata, this.outputMetadata, this.parameters, name);
        }
    }
}

