/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.client;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.client.Hop;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.client.LinkDiscoverers;
import org.springframework.hateoas.client.Rels;
import org.springframework.hateoas.client.TraversonDefaults;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class Traverson {
    private static final TraversonDefaults DEFAULTS;
    private final URI baseUri;
    private final List<MediaType> mediaTypes;
    private RestOperations operations;
    private LinkDiscoverers discoverers;

    public Traverson(URI baseUri, MediaType ... mediaTypes) {
        this(baseUri, Arrays.asList(mediaTypes));
    }

    public Traverson(URI baseUri, List<MediaType> mediaTypes) {
        Assert.notNull((Object)baseUri, (String)"Base URI must not be null!");
        Assert.notEmpty(mediaTypes, (String)"At least one media type must be given!");
        this.mediaTypes = mediaTypes;
        this.baseUri = baseUri;
        this.setLinkDiscoverers(DEFAULTS.getLinkDiscoverers(mediaTypes));
        this.setRestOperations(Traverson.createDefaultTemplate(this.mediaTypes));
    }

    public static List<HttpMessageConverter<?>> getDefaultMessageConverters(MediaType ... mediaTypes) {
        return DEFAULTS.getHttpMessageConverters(Arrays.asList(mediaTypes));
    }

    private static RestOperations createDefaultTemplate(List<MediaType> mediaTypes) {
        RestTemplate template = new RestTemplate();
        template.setMessageConverters(DEFAULTS.getHttpMessageConverters(mediaTypes));
        return template;
    }

    public Traverson setRestOperations(@Nullable RestOperations operations) {
        this.operations = operations == null ? Traverson.createDefaultTemplate(this.mediaTypes) : operations;
        return this;
    }

    public Traverson setLinkDiscoverers(@Nullable List<? extends LinkDiscoverer> discoverer) {
        List<? extends LinkDiscoverer> defaultedDiscoverers = discoverer == null ? DEFAULTS.getLinkDiscoverers(this.mediaTypes) : discoverer;
        this.discoverers = new LinkDiscoverers((PluginRegistry<LinkDiscoverer, MediaType>)PluginRegistry.of(defaultedDiscoverers));
        return this;
    }

    public TraversalBuilder follow(String ... rels) {
        return new TraversalBuilder().follow(rels);
    }

    public TraversalBuilder follow(Hop hop) {
        return new TraversalBuilder().follow(hop);
    }

    private HttpEntity<?> prepareRequest(HttpHeaders headers) {
        HttpHeaders toSend = new HttpHeaders();
        toSend.putAll((Map)headers);
        if (headers.getAccept().isEmpty()) {
            toSend.setAccept(this.mediaTypes);
        }
        return new HttpEntity((MultiValueMap)toSend);
    }

    static {
        List ALL_DEFAULTS = SpringFactoriesLoader.loadFactories(TraversonDefaults.class, (ClassLoader)Traverson.class.getClassLoader());
        Assert.isTrue((ALL_DEFAULTS.size() == 1 ? 1 : 0) != 0, () -> String.format("Expected to find only one TraversonDefaults instance, but found: %s", ALL_DEFAULTS.stream().map(Object::getClass).map(Class::getName).collect(Collectors.joining(", "))));
        DEFAULTS = (TraversonDefaults)ALL_DEFAULTS.get(0);
    }

    private static final class URIAndHeaders {
        private final URI uri;
        private final HttpHeaders httpHeaders;

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public HttpHeaders getHttpHeaders() {
            return this.httpHeaders;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof URIAndHeaders)) {
                return false;
            }
            URIAndHeaders other = (URIAndHeaders)o;
            URI this$uri = this.getUri();
            URI other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
                return false;
            }
            HttpHeaders this$httpHeaders = this.getHttpHeaders();
            HttpHeaders other$httpHeaders = other.getHttpHeaders();
            return !(this$httpHeaders == null ? other$httpHeaders != null : !this$httpHeaders.equals(other$httpHeaders));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URI $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
            HttpHeaders $httpHeaders = this.getHttpHeaders();
            result = result * 59 + ($httpHeaders == null ? 43 : $httpHeaders.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Traverson.URIAndHeaders(uri=" + this.getUri() + ", httpHeaders=" + this.getHttpHeaders() + ")";
        }

        @Generated
        public URIAndHeaders(URI uri, HttpHeaders httpHeaders) {
            this.uri = uri;
            this.httpHeaders = httpHeaders;
        }
    }

    private static final class UriStringAndHeaders {
        private final String uri;
        private final HttpHeaders httpHeaders;

        @Generated
        public String getUri() {
            return this.uri;
        }

        @Generated
        public HttpHeaders getHttpHeaders() {
            return this.httpHeaders;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UriStringAndHeaders)) {
                return false;
            }
            UriStringAndHeaders other = (UriStringAndHeaders)o;
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            HttpHeaders this$httpHeaders = this.getHttpHeaders();
            HttpHeaders other$httpHeaders = other.getHttpHeaders();
            return !(this$httpHeaders == null ? other$httpHeaders != null : !this$httpHeaders.equals(other$httpHeaders));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            HttpHeaders $httpHeaders = this.getHttpHeaders();
            result = result * 59 + ($httpHeaders == null ? 43 : $httpHeaders.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Traverson.UriStringAndHeaders(uri=" + this.getUri() + ", httpHeaders=" + this.getHttpHeaders() + ")";
        }

        @Generated
        public UriStringAndHeaders(String uri, HttpHeaders httpHeaders) {
            this.uri = uri;
            this.httpHeaders = httpHeaders;
        }
    }

    public class TraversalBuilder {
        private static final String MEDIA_TYPE_HEADER_NOT_FOUND = "Response for request to %s did not expose a content type! Unable to identify links!";
        private static final String LINK_NOT_FOUND = "Expected to find link with rel '%s' in response %s!";
        private final List<Hop> rels = new ArrayList<Hop>();
        private Map<String, Object> templateParameters = new HashMap<String, Object>();
        private HttpHeaders headers = new HttpHeaders();

        private TraversalBuilder() {
        }

        public TraversalBuilder follow(String ... rels) {
            Assert.notNull((Object)rels, (String)"Rels must not be null!");
            Arrays.stream(rels).map(Hop::rel).forEach(this.rels::add);
            return this;
        }

        public TraversalBuilder follow(Hop hop) {
            Assert.notNull((Object)hop, (String)"Hop must not be null!");
            this.rels.add(hop);
            return this;
        }

        public TraversalBuilder withTemplateParameters(Map<String, Object> parameters) {
            Assert.notNull(parameters, (String)"Parameters must not be null!");
            this.templateParameters = parameters;
            return this;
        }

        public TraversalBuilder withHeaders(HttpHeaders headers) {
            Assert.notNull((Object)headers, (String)"Headers must not be null!");
            this.headers = headers;
            return this;
        }

        @Nullable
        public <T> T toObject(Class<T> type) {
            Assert.notNull(type, (String)"Target type must not be null!");
            URIAndHeaders uriAndHeaders = this.traverseToExpandedFinalUrl();
            HttpEntity requestEntity = Traverson.this.prepareRequest(this.mergeHeaders(this.headers, uriAndHeaders.getHttpHeaders()));
            return (T)Traverson.this.operations.exchange(uriAndHeaders.getUri(), HttpMethod.GET, requestEntity, type).getBody();
        }

        @Nullable
        public <T> T toObject(ParameterizedTypeReference<T> type) {
            Assert.notNull(type, (String)"Target type must not be null!");
            URIAndHeaders uriAndHeaders = this.traverseToExpandedFinalUrl();
            HttpEntity requestEntity = Traverson.this.prepareRequest(this.mergeHeaders(this.headers, uriAndHeaders.getHttpHeaders()));
            return (T)Traverson.this.operations.exchange(uriAndHeaders.getUri(), HttpMethod.GET, requestEntity, type).getBody();
        }

        public <T> T toObject(String jsonPath) {
            Assert.hasText((String)jsonPath, (String)"JSON path must not be null or empty!");
            URIAndHeaders uriAndHeaders = this.traverseToExpandedFinalUrl();
            HttpEntity requestEntity = Traverson.this.prepareRequest(this.mergeHeaders(this.headers, uriAndHeaders.getHttpHeaders()));
            String forObject = (String)Traverson.this.operations.exchange(uriAndHeaders.getUri(), HttpMethod.GET, requestEntity, String.class).getBody();
            return (T)JsonPath.read((String)forObject, (String)jsonPath, (Predicate[])new Predicate[0]);
        }

        public <T> ResponseEntity<T> toEntity(Class<T> type) {
            Assert.notNull(type, (String)"Target type must not be null!");
            URIAndHeaders uriAndHeaders = this.traverseToExpandedFinalUrl();
            HttpEntity requestEntity = Traverson.this.prepareRequest(this.mergeHeaders(this.headers, uriAndHeaders.getHttpHeaders()));
            return Traverson.this.operations.exchange(uriAndHeaders.getUri(), HttpMethod.GET, requestEntity, type);
        }

        public Link asLink() {
            return this.traverseToLink(true);
        }

        public Link asTemplatedLink() {
            return this.traverseToLink(false);
        }

        private Link traverseToLink(boolean expandFinalUrl) {
            Assert.isTrue((this.rels.size() > 0 ? 1 : 0) != 0, (String)"At least one rel needs to be provided!");
            return Link.of(expandFinalUrl ? this.traverseToExpandedFinalUrl().getUri().toString() : this.traverseToFinalUrl().getUri(), this.rels.get(this.rels.size() - 1).getRel());
        }

        private UriStringAndHeaders traverseToFinalUrl() {
            UriStringAndHeaders uriAndHeaders = this.getAndFindLinkWithRel(Traverson.this.baseUri.toString(), this.rels.iterator(), HttpHeaders.EMPTY);
            return new UriStringAndHeaders(UriTemplate.of(uriAndHeaders.getUri()).toString(), uriAndHeaders.getHttpHeaders());
        }

        private URIAndHeaders traverseToExpandedFinalUrl() {
            UriStringAndHeaders uriAndHeaders = this.getAndFindLinkWithRel(Traverson.this.baseUri.toString(), this.rels.iterator(), HttpHeaders.EMPTY);
            return new URIAndHeaders(UriTemplate.of(uriAndHeaders.getUri()).expand(this.templateParameters), uriAndHeaders.getHttpHeaders());
        }

        private UriStringAndHeaders getAndFindLinkWithRel(String uri, Iterator<Hop> rels, HttpHeaders extraHeaders) {
            if (!rels.hasNext()) {
                return new UriStringAndHeaders(uri, extraHeaders);
            }
            HttpEntity request = Traverson.this.prepareRequest(this.mergeHeaders(this.headers, extraHeaders));
            URI target = UriTemplate.of(uri).expand(new Object[0]);
            ResponseEntity responseEntity = Traverson.this.operations.exchange(target, HttpMethod.GET, request, String.class);
            MediaType contentType = responseEntity.getHeaders().getContentType();
            if (contentType == null) {
                throw new IllegalStateException(String.format(MEDIA_TYPE_HEADER_NOT_FOUND, target));
            }
            String responseBody = (String)responseEntity.getBody();
            Hop thisHop = rels.next();
            Rels.Rel rel = Rels.getRelFor(thisHop.getRel(), Traverson.this.discoverers);
            Link link = rel.findInResponse(responseBody == null ? "" : responseBody, contentType).orElseThrow(() -> new IllegalStateException(String.format(LINK_NOT_FOUND, rel, responseBody)));
            String linkTarget = thisHop.hasParameters() ? link.expand(thisHop.getMergedParameters(this.templateParameters)).getHref() : link.getHref();
            return this.getAndFindLinkWithRel(linkTarget, rels, thisHop.getHeaders());
        }

        private HttpHeaders mergeHeaders(HttpHeaders headersA, HttpHeaders headersB) {
            HttpHeaders mergedHeaders = new HttpHeaders();
            mergedHeaders.addAll((MultiValueMap)headersA);
            mergedHeaders.addAll((MultiValueMap)headersB);
            return mergedHeaders;
        }
    }
}

