/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.uber;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.QueryParameter;
import org.springframework.hateoas.mediatype.uber.UberAction;
import org.springframework.hateoas.mediatype.uber.UberData;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;

class UberAffordanceModel
extends AffordanceModel {
    private static final Set<HttpMethod> ENTITY_ALTERING_METHODS = EnumSet.of(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH);
    private final Collection<MediaType> mediaTypes = Collections.singleton(MediaTypes.UBER_JSON);
    private final List<UberData> inputProperties = this.determineAffordanceInputs();
    private final List<UberData> queryProperties = this.determineQueryProperties();

    UberAffordanceModel(String name, Link link, HttpMethod httpMethod, AffordanceModel.InputPayloadMetadata inputType, List<QueryParameter> queryMethodParameters, AffordanceModel.PayloadMetadata outputType) {
        super(name, link, httpMethod, inputType, queryMethodParameters, outputType);
    }

    private List<UberData> determineAffordanceInputs() {
        if (!ENTITY_ALTERING_METHODS.contains(this.getHttpMethod())) {
            return Collections.emptyList();
        }
        return this.getInput().stream().map(AffordanceModel.PropertyMetadata::getName).map(propertyName -> new UberData().withName((String)propertyName).withValue("")).collect(Collectors.toList());
    }

    private List<UberData> determineQueryProperties() {
        if (!this.getHttpMethod().equals((Object)HttpMethod.GET)) {
            return Collections.emptyList();
        }
        if (this.getHttpMethod().equals((Object)HttpMethod.GET)) {
            return this.getQueryMethodParameters().stream().map(queryParameter -> new UberData().withName(queryParameter.getName()).withValue("")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nullable
    UberAction getAction() {
        return UberAction.forRequestMethod(this.getHttpMethod());
    }

    @Generated
    public Collection<MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    @Generated
    public List<UberData> getInputProperties() {
        return this.inputProperties;
    }

    @Generated
    public List<UberData> getQueryProperties() {
        return this.queryProperties;
    }
}

