/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsDeserializers;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsProperty;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NON_PRIVATE)
@JsonIgnoreProperties(value={"httpMethod", "contentTypes"})
@JsonPropertyOrder(value={"title", "method", "contentType", "properties"})
public class HalFormsTemplate {
    public static final String DEFAULT_KEY = "default";
    private String title;
    private HttpMethod httpMethod;
    private List<HalFormsProperty> properties;
    private List<MediaType> contentTypes;

    private HalFormsTemplate() {
        this(null, null, Collections.emptyList(), Collections.emptyList());
    }

    public static HalFormsTemplate forMethod(HttpMethod httpMethod) {
        return new HalFormsTemplate().withHttpMethod(httpMethod);
    }

    public HalFormsTemplate andProperty(HalFormsProperty property) {
        Assert.notNull((Object)property, (String)"Property must not be null!");
        ArrayList<HalFormsProperty> properties = new ArrayList<HalFormsProperty>(this.properties);
        properties.add(property);
        return new HalFormsTemplate(this.title, this.httpMethod, properties, this.contentTypes);
    }

    public HalFormsTemplate andContentType(MediaType mediaType) {
        Assert.notNull((Object)mediaType, (String)"Media type must not be null!");
        ArrayList<MediaType> contentTypes = new ArrayList<MediaType>(this.contentTypes);
        contentTypes.add(mediaType);
        return new HalFormsTemplate(this.title, this.httpMethod, this.properties, contentTypes);
    }

    String getContentType() {
        return StringUtils.collectionToDelimitedString(this.contentTypes, (String)", ");
    }

    @JsonDeserialize(using=HalFormsDeserializers.MediaTypesDeserializer.class)
    void setContentType(List<MediaType> mediaTypes) {
        this.contentTypes = mediaTypes;
    }

    String getMethod() {
        return this.httpMethod == null ? null : this.httpMethod.toString().toLowerCase();
    }

    void setMethod(String method) {
        this.httpMethod = HttpMethod.valueOf((String)method.toUpperCase());
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Generated
    public List<HalFormsProperty> getProperties() {
        return this.properties;
    }

    @Generated
    public List<MediaType> getContentTypes() {
        return this.contentTypes;
    }

    @Generated
    public HalFormsTemplate withTitle(String title) {
        return this.title == title ? this : new HalFormsTemplate(title, this.httpMethod, this.properties, this.contentTypes);
    }

    @Generated
    public HalFormsTemplate withProperties(List<HalFormsProperty> properties) {
        return this.properties == properties ? this : new HalFormsTemplate(this.title, this.httpMethod, properties, this.contentTypes);
    }

    @Generated
    public HalFormsTemplate withContentTypes(List<MediaType> contentTypes) {
        return this.contentTypes == contentTypes ? this : new HalFormsTemplate(this.title, this.httpMethod, this.properties, contentTypes);
    }

    @Generated
    private HalFormsTemplate(String title, HttpMethod httpMethod, List<HalFormsProperty> properties, List<MediaType> contentTypes) {
        this.title = title;
        this.httpMethod = httpMethod;
        this.properties = properties;
        this.contentTypes = contentTypes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HalFormsTemplate)) {
            return false;
        }
        HalFormsTemplate other = (HalFormsTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        HttpMethod this$httpMethod = this.getHttpMethod();
        HttpMethod other$httpMethod = other.getHttpMethod();
        if (this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod)) {
            return false;
        }
        List<HalFormsProperty> this$properties = this.getProperties();
        List<HalFormsProperty> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<MediaType> this$contentTypes = this.getContentTypes();
        List<MediaType> other$contentTypes = other.getContentTypes();
        return !(this$contentTypes == null ? other$contentTypes != null : !((Object)this$contentTypes).equals(other$contentTypes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HalFormsTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        HttpMethod $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
        List<HalFormsProperty> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<MediaType> $contentTypes = this.getContentTypes();
        result = result * 59 + ($contentTypes == null ? 43 : ((Object)$contentTypes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HalFormsTemplate(title=" + this.getTitle() + ", httpMethod=" + this.getHttpMethod() + ", properties=" + this.getProperties() + ", contentTypes=" + this.getContentTypes() + ")";
    }

    @Generated
    private HalFormsTemplate withHttpMethod(HttpMethod httpMethod) {
        return this.httpMethod == httpMethod ? this : new HalFormsTemplate(this.title, httpMethod, this.properties, this.contentTypes);
    }
}

