/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.BeanUtils;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.support.WebStack;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PropertyUtils {
    private static final HashSet<String> FIELDS_TO_IGNORE = new HashSet();

    public static Map<String, Object> findProperties(Object object) {
        if (object.getClass().equals(EntityModel.class)) {
            return PropertyUtils.findProperties(((EntityModel)object).getContent());
        }
        return PropertyUtils.getPropertyDescriptors(object.getClass()).collect(HashMap::new, (hashMap, descriptor) -> {
            try {
                Method readMethod = descriptor.getReadMethod();
                ReflectionUtils.makeAccessible((Method)readMethod);
                hashMap.put(descriptor.getName(), readMethod.invoke(object, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }, HashMap::putAll);
    }

    public static List<String> findPropertyNames(ResolvableType resolvableType) {
        if (WebStack.WEBFLUX.isAvailable() && (Mono.class.equals((Object)resolvableType.getRawClass()) || Flux.class.equals((Object)resolvableType.getRawClass()))) {
            ResolvableType generic = resolvableType.getGeneric(new int[]{0});
            return PropertyUtils.findPropertyNames(generic);
        }
        if (resolvableType.getRawClass().equals(EntityModel.class)) {
            return PropertyUtils.findPropertyNames(resolvableType.resolveGeneric(new int[]{0}));
        }
        return PropertyUtils.findPropertyNames(resolvableType.getRawClass());
    }

    public static List<String> findPropertyNames(Class<?> clazz) {
        return PropertyUtils.getPropertyDescriptors(clazz).map(FeatureDescriptor::getName).collect(Collectors.toList());
    }

    public static <T> T createObjectFromProperties(Class<T> clazz, Map<String, Object> properties) {
        Object obj = BeanUtils.instantiateClass(clazz);
        properties.forEach((key, value) -> {
            Optional<PropertyDescriptor> possibleProperty = Optional.ofNullable(BeanUtils.getPropertyDescriptor((Class)clazz, (String)key));
            possibleProperty.ifPresent(property -> {
                try {
                    Method writeMethod = property.getWriteMethod();
                    ReflectionUtils.makeAccessible((Method)writeMethod);
                    writeMethod.invoke(obj, value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            });
        });
        return (T)obj;
    }

    private static Stream<PropertyDescriptor> getPropertyDescriptors(Class<?> clazz) {
        return Arrays.stream(BeanUtils.getPropertyDescriptors(clazz)).filter(descriptor -> !FIELDS_TO_IGNORE.contains(descriptor.getName())).filter(descriptor -> !PropertyUtils.descriptorToBeIgnoredByJackson(clazz, descriptor)).filter(descriptor -> !PropertyUtils.toBeIgnoredByJackson(clazz, descriptor.getName())).filter(descriptor -> !PropertyUtils.readerIsNotToBeIgnoredByJackson(descriptor));
    }

    private static boolean descriptorToBeIgnoredByJackson(Class<?> clazz, PropertyDescriptor descriptor) {
        Field descriptorField = ReflectionUtils.findField(clazz, (String)descriptor.getName());
        return PropertyUtils.toBeIgnoredByJackson(AnnotationUtils.getAnnotations((AnnotatedElement)descriptorField));
    }

    private static boolean readerIsNotToBeIgnoredByJackson(PropertyDescriptor descriptor) {
        return PropertyUtils.toBeIgnoredByJackson(AnnotationUtils.getAnnotations((Method)descriptor.getReadMethod()));
    }

    private static boolean toBeIgnoredByJackson(Annotation[] annotations) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().equals(JsonIgnore.class)) continue;
                return (Boolean)AnnotationUtils.getAnnotationAttributes((Annotation)annotation).get("value");
            }
        }
        return false;
    }

    private static boolean toBeIgnoredByJackson(Class<?> clazz, String field) {
        for (Annotation annotation : AnnotationUtils.getAnnotations(clazz)) {
            String[] namesOfPropertiesToIgnore;
            if (!annotation.annotationType().equals(JsonIgnoreProperties.class)) continue;
            for (String propertyToIgnore : namesOfPropertiesToIgnore = (String[])AnnotationUtils.getAnnotationAttributes((Annotation)annotation).get("value")) {
                if (!propertyToIgnore.equalsIgnoreCase(field)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        FIELDS_TO_IGNORE.add("class");
        FIELDS_TO_IGNORE.add("links");
    }
}

