/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.server.mvc.TypeConstrainedMappingJackson2HttpMessageConverter;
import org.springframework.hateoas.server.mvc.UriComponentsContributor;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilderFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
class WebMvcHateoasConfiguration {
    WebMvcHateoasConfiguration() {
    }

    @Bean
    HypermediaWebMvcConfigurer hypermediaWebMvcConfigurer(ObjectProvider<ObjectMapper> mapper, Collection<HypermediaMappingInformation> hypermediaTypes) {
        return new HypermediaWebMvcConfigurer((ObjectMapper)mapper.getIfAvailable(ObjectMapper::new), hypermediaTypes);
    }

    @Bean
    static HypermediaRestTemplateBeanPostProcessor restTemplateBeanPostProcessor(ObjectProvider<HypermediaWebMvcConfigurer> configurer) {
        return new HypermediaRestTemplateBeanPostProcessor(configurer);
    }

    @Bean
    WebMvcLinkBuilderFactory webMvcLinkBuilderFactory(ObjectProvider<UriComponentsContributor> contributors) {
        WebMvcLinkBuilderFactory factory = new WebMvcLinkBuilderFactory();
        factory.setUriComponentsContributors(contributors.stream().collect(Collectors.toList()));
        return factory;
    }

    static class HypermediaRestTemplateBeanPostProcessor
    implements BeanPostProcessor {
        private final ObjectProvider<HypermediaWebMvcConfigurer> configurer;

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (!RestTemplate.class.isInstance(bean)) {
                return bean;
            }
            ((HypermediaWebMvcConfigurer)this.configurer.getObject()).extendMessageConverters(((RestTemplate)bean).getMessageConverters());
            return bean;
        }

        @Generated
        public HypermediaRestTemplateBeanPostProcessor(ObjectProvider<HypermediaWebMvcConfigurer> configurer) {
            this.configurer = configurer;
        }
    }

    static class HypermediaWebMvcConfigurer
    implements WebMvcConfigurer {
        private final ObjectMapper mapper;
        private final Collection<HypermediaMappingInformation> hypermediaTypes;

        public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
            this.hypermediaTypes.forEach(hypermedia -> converters.add(0, (HttpMessageConverter<?>)new TypeConstrainedMappingJackson2HttpMessageConverter(RepresentationModel.class, hypermedia.getMediaTypes(), hypermedia.configureObjectMapper(this.mapper.copy()))));
        }

        @Generated
        public HypermediaWebMvcConfigurer(ObjectMapper mapper, Collection<HypermediaMappingInformation> hypermediaTypes) {
            this.mapper = mapper;
            this.hypermediaTypes = hypermediaTypes;
        }
    }
}

