/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import lombok.Generated;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.codec.CharSequenceEncoder;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.codec.StringDecoder;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.config.WebClientConfigurer;
import org.springframework.hateoas.server.reactive.HypermediaWebFilter;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
class WebFluxHateoasConfiguration {
    WebFluxHateoasConfiguration() {
    }

    @Bean
    WebClientConfigurer webClientConfigurer(ObjectProvider<ObjectMapper> mapper, Collection<HypermediaMappingInformation> hypermediaTypes) {
        return new WebClientConfigurer((ObjectMapper)mapper.getIfAvailable(ObjectMapper::new), hypermediaTypes);
    }

    @Bean
    static HypermediaWebClientBeanPostProcessor webClientBeanPostProcessor(ObjectProvider<WebClientConfigurer> configurer) {
        return new HypermediaWebClientBeanPostProcessor(configurer);
    }

    @Bean
    HypermediaWebFluxConfigurer hypermediaWebFluxConfigurer(ObjectProvider<ObjectMapper> mapper, Collection<HypermediaMappingInformation> hypermediaTypes) {
        return new HypermediaWebFluxConfigurer((ObjectMapper)mapper.getIfAvailable(ObjectMapper::new), hypermediaTypes);
    }

    @Bean
    @Lazy
    HypermediaWebFilter hypermediaWebFilter() {
        return new HypermediaWebFilter();
    }

    static class HypermediaWebFluxConfigurer
    implements WebFluxConfigurer {
        private final ObjectMapper mapper;
        private final Collection<HypermediaMappingInformation> hypermediaTypes;

        public void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
            CodecConfigurer.CustomCodecs customCodecs = configurer.customCodecs();
            this.hypermediaTypes.forEach(hypermedia -> {
                MimeType[] mimeTypes = hypermedia.getMediaTypes().toArray(new MimeType[0]);
                ObjectMapper objectMapper = hypermedia.configureObjectMapper(this.mapper.copy());
                customCodecs.encoder((Encoder)new Jackson2JsonEncoder(objectMapper, mimeTypes));
                customCodecs.decoder((Decoder)new Jackson2JsonDecoder(objectMapper, mimeTypes));
            });
            customCodecs.encoder((Encoder)CharSequenceEncoder.allMimeTypes());
            customCodecs.decoder((Decoder)StringDecoder.allMimeTypes());
            configurer.registerDefaults(false);
        }

        @Generated
        public HypermediaWebFluxConfigurer(ObjectMapper mapper, Collection<HypermediaMappingInformation> hypermediaTypes) {
            this.mapper = mapper;
            this.hypermediaTypes = hypermediaTypes;
        }
    }

    static class HypermediaWebClientBeanPostProcessor
    implements BeanPostProcessor {
        private final ObjectProvider<WebClientConfigurer> configurer;

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof WebClient) {
                return ((WebClientConfigurer)this.configurer.getObject()).registerHypermediaTypes((WebClient)bean);
            }
            return bean;
        }

        @Generated
        public HypermediaWebClientBeanPostProcessor(ObjectProvider<WebClientConfigurer> configurer) {
            this.configurer = configurer;
        }
    }
}

