/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.QueryParameter;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.UriTemplate;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"templated"}, ignoreUnknown=true)
public class Link
implements Serializable {
    private static final long serialVersionUID = -9037755944661782121L;
    private static final String URI_PATTERN = "(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
    private static final Pattern URI_AND_ATTRIBUTES_PATTERN = Pattern.compile("<(.*)>;(.*)");
    private static final Pattern KEY_AND_VALUE_PATTERN = Pattern.compile("(\\w+)=\"(\\p{Lower}[\\p{Lower}\\p{Digit}.\\-\\s]*|(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])\"");
    public static final String ATOM_NAMESPACE = "http://www.w3.org/2005/Atom";
    @Deprecated
    public static final LinkRelation REL_SELF = IanaLinkRelations.SELF;
    @Deprecated
    public static final LinkRelation REL_FIRST = IanaLinkRelations.FIRST;
    @Deprecated
    public static final LinkRelation REL_PREVIOUS = IanaLinkRelations.PREV;
    @Deprecated
    public static final LinkRelation REL_NEXT = IanaLinkRelations.NEXT;
    @Deprecated
    public static final LinkRelation REL_LAST = IanaLinkRelations.LAST;
    private LinkRelation rel;
    private String href;
    private String hreflang;
    private String media;
    private String title;
    private String type;
    private String deprecation;
    private String profile;
    private String name;
    @JsonIgnore
    private UriTemplate template;
    @JsonIgnore
    private List<Affordance> affordances;

    public Link(String href) {
        this(href, IanaLinkRelations.SELF);
    }

    public Link(String href, String rel) {
        this(new UriTemplate(href), LinkRelation.of(rel));
    }

    public Link(String href, LinkRelation rel) {
        this(new UriTemplate(href), rel);
    }

    public Link(UriTemplate template, String rel) {
        this(template, LinkRelation.of(rel));
    }

    public Link(UriTemplate template, LinkRelation rel) {
        this(template, rel, Collections.emptyList());
    }

    private Link(UriTemplate template, LinkRelation rel, List<Affordance> affordances) {
        Assert.notNull((Object)template, (String)"UriTemplate must not be null!");
        Assert.notNull((Object)rel, (String)"LinkRelation must not be null!");
        Assert.notNull(affordances, (String)"Affordances must not be null!");
        this.template = template;
        this.rel = rel;
        this.href = template.toString();
        this.affordances = affordances;
    }

    protected Link() {
        this.affordances = new ArrayList<Affordance>();
    }

    public List<Affordance> getAffordances() {
        return Collections.unmodifiableList(this.affordances);
    }

    public Link withSelfRel() {
        return this.withRel(IanaLinkRelations.SELF);
    }

    public Link andAffordance(Affordance affordance) {
        Assert.notNull((Object)affordance, (String)"Affordance must not be null!");
        ArrayList<Affordance> newAffordances = new ArrayList<Affordance>();
        newAffordances.addAll(this.affordances);
        newAffordances.add(affordance);
        return this.withAffordances(newAffordances);
    }

    public Link andAffordance(String name, HttpMethod httpMethod, ResolvableType inputType, List<QueryParameter> queryMethodParameters, ResolvableType outputType) {
        return this.andAffordance(new Affordance(name, this, httpMethod, inputType, queryMethodParameters, outputType));
    }

    public Link andAffordance(HttpMethod httpMethod, ResolvableType inputType, List<QueryParameter> queryMethodParameters, ResolvableType outputType) {
        return this.andAffordance(httpMethod.toString().toLowerCase() + inputType.resolve().getSimpleName(), httpMethod, inputType, queryMethodParameters, outputType);
    }

    public Link andAffordance(HttpMethod httpMethod, Class<?> inputType, List<QueryParameter> queryMethodParameters, Class<?> outputType) {
        return this.andAffordance(httpMethod, ResolvableType.forClass(inputType), queryMethodParameters, ResolvableType.forClass(outputType));
    }

    public Link andAffordances(List<Affordance> affordances) {
        ArrayList<Affordance> newAffordances = new ArrayList<Affordance>();
        newAffordances.addAll(this.affordances);
        newAffordances.addAll(affordances);
        return this.withAffordances(newAffordances);
    }

    public Link withAffordances(List<Affordance> affordances) {
        return new Link(this.rel, this.href, this.hreflang, this.media, this.title, this.type, this.deprecation, this.profile, this.name, this.template, affordances);
    }

    @JsonIgnore
    public List<String> getVariableNames() {
        return this.getUriTemplate().getVariableNames();
    }

    @JsonIgnore
    public List<TemplateVariable> getVariables() {
        return this.getUriTemplate().getVariables();
    }

    public boolean isTemplated() {
        return !this.getUriTemplate().getVariables().isEmpty();
    }

    public Link expand(Object ... arguments) {
        return new Link(this.getUriTemplate().expand(arguments).toString(), this.getRel());
    }

    public Link expand(Map<String, ? extends Object> arguments) {
        return new Link(this.getUriTemplate().expand(arguments).toString(), this.getRel());
    }

    public Link withRel(LinkRelation relation) {
        Assert.notNull((Object)relation, (String)"LinkRelation must not be null!");
        return new Link(relation, this.href, this.hreflang, this.media, this.title, this.type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    public Link withRel(String relation) {
        return this.withRel(LinkRelation.of(relation));
    }

    public boolean hasRel(String rel) {
        Assert.hasText((String)rel, (String)"Link relation must not be null or empty!");
        return this.hasRel(LinkRelation.of(rel));
    }

    public boolean hasRel(LinkRelation rel) {
        Assert.notNull((Object)rel, (String)"Link relation must not be null!");
        return this.rel.isSameAs(rel);
    }

    private UriTemplate getUriTemplate() {
        if (this.template == null) {
            this.template = new UriTemplate(this.href);
        }
        return this.template;
    }

    public URI toUri() {
        try {
            return URI.create(this.expand(new Object[0]).getHref());
        }
        catch (IllegalArgumentException o_O) {
            throw new IllegalStateException(o_O);
        }
    }

    public String toString() {
        String linkString = String.format("<%s>;rel=\"%s\"", this.href, this.rel.value());
        if (this.hreflang != null) {
            linkString = linkString + ";hreflang=\"" + this.hreflang + "\"";
        }
        if (this.media != null) {
            linkString = linkString + ";media=\"" + this.media + "\"";
        }
        if (this.title != null) {
            linkString = linkString + ";title=\"" + this.title + "\"";
        }
        if (this.type != null) {
            linkString = linkString + ";type=\"" + this.type + "\"";
        }
        if (this.deprecation != null) {
            linkString = linkString + ";deprecation=\"" + this.deprecation + "\"";
        }
        if (this.profile != null) {
            linkString = linkString + ";profile=\"" + this.profile + "\"";
        }
        if (this.name != null) {
            linkString = linkString + ";name=\"" + this.name + "\"";
        }
        return linkString;
    }

    public static Link valueOf(String element) {
        if (!StringUtils.hasText((String)element)) {
            return null;
        }
        Matcher matcher = URI_AND_ATTRIBUTES_PATTERN.matcher(element);
        if (matcher.find()) {
            Map<String, String> attributes = Link.getAttributeMap(matcher.group(2));
            if (!attributes.containsKey("rel")) {
                throw new IllegalArgumentException("Link does not provide a rel attribute!");
            }
            Link link = new Link(matcher.group(1), attributes.get("rel"));
            if (attributes.containsKey("hreflang")) {
                link = link.withHreflang(attributes.get("hreflang"));
            }
            if (attributes.containsKey("media")) {
                link = link.withMedia(attributes.get("media"));
            }
            if (attributes.containsKey("title")) {
                link = link.withTitle(attributes.get("title"));
            }
            if (attributes.containsKey("type")) {
                link = link.withType(attributes.get("type"));
            }
            if (attributes.containsKey("deprecation")) {
                link = link.withDeprecation(attributes.get("deprecation"));
            }
            if (attributes.containsKey("profile")) {
                link = link.withProfile(attributes.get("profile"));
            }
            if (attributes.containsKey("name")) {
                link = link.withName(attributes.get("name"));
            }
            return link;
        }
        throw new IllegalArgumentException(String.format("Given link header %s is not RFC5988 compliant!", element));
    }

    private static Map<String, String> getAttributeMap(String source) {
        if (!StringUtils.hasText((String)source)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        Matcher matcher = KEY_AND_VALUE_PATTERN.matcher(source);
        while (matcher.find()) {
            attributes.put(matcher.group(1), matcher.group(2));
        }
        return attributes;
    }

    @Generated
    Link(LinkRelation rel, String href, String hreflang, String media, String title, String type, String deprecation, String profile, String name, UriTemplate template, List<Affordance> affordances) {
        this.rel = rel;
        this.href = href;
        this.hreflang = hreflang;
        this.media = media;
        this.title = title;
        this.type = type;
        this.deprecation = deprecation;
        this.profile = profile;
        this.name = name;
        this.template = template;
        this.affordances = affordances;
    }

    @Generated
    public LinkRelation getRel() {
        return this.rel;
    }

    @Generated
    public String getHref() {
        return this.href;
    }

    @Generated
    public String getHreflang() {
        return this.hreflang;
    }

    @Generated
    public String getMedia() {
        return this.media;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getDeprecation() {
        return this.deprecation;
    }

    @Generated
    public String getProfile() {
        return this.profile;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public UriTemplate getTemplate() {
        return this.template;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Link)) {
            return false;
        }
        Link other = (Link)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LinkRelation this$rel = this.getRel();
        LinkRelation other$rel = other.getRel();
        if (this$rel == null ? other$rel != null : !this$rel.equals(other$rel)) {
            return false;
        }
        String this$href = this.getHref();
        String other$href = other.getHref();
        if (this$href == null ? other$href != null : !this$href.equals(other$href)) {
            return false;
        }
        String this$hreflang = this.getHreflang();
        String other$hreflang = other.getHreflang();
        if (this$hreflang == null ? other$hreflang != null : !this$hreflang.equals(other$hreflang)) {
            return false;
        }
        String this$media = this.getMedia();
        String other$media = other.getMedia();
        if (this$media == null ? other$media != null : !this$media.equals(other$media)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$deprecation = this.getDeprecation();
        String other$deprecation = other.getDeprecation();
        if (this$deprecation == null ? other$deprecation != null : !this$deprecation.equals(other$deprecation)) {
            return false;
        }
        String this$profile = this.getProfile();
        String other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Affordance> this$affordances = this.getAffordances();
        List<Affordance> other$affordances = other.getAffordances();
        return !(this$affordances == null ? other$affordances != null : !((Object)this$affordances).equals(other$affordances));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Link;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LinkRelation $rel = this.getRel();
        result = result * 59 + ($rel == null ? 43 : $rel.hashCode());
        String $href = this.getHref();
        result = result * 59 + ($href == null ? 43 : $href.hashCode());
        String $hreflang = this.getHreflang();
        result = result * 59 + ($hreflang == null ? 43 : $hreflang.hashCode());
        String $media = this.getMedia();
        result = result * 59 + ($media == null ? 43 : $media.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $deprecation = this.getDeprecation();
        result = result * 59 + ($deprecation == null ? 43 : $deprecation.hashCode());
        String $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Affordance> $affordances = this.getAffordances();
        result = result * 59 + ($affordances == null ? 43 : ((Object)$affordances).hashCode());
        return result;
    }

    @Generated
    public Link withHref(String href) {
        return this.href == href ? this : new Link(this.rel, href, this.hreflang, this.media, this.title, this.type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    @Generated
    public Link withHreflang(String hreflang) {
        return this.hreflang == hreflang ? this : new Link(this.rel, this.href, hreflang, this.media, this.title, this.type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    @Generated
    public Link withMedia(String media) {
        return this.media == media ? this : new Link(this.rel, this.href, this.hreflang, media, this.title, this.type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    @Generated
    public Link withTitle(String title) {
        return this.title == title ? this : new Link(this.rel, this.href, this.hreflang, this.media, title, this.type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    @Generated
    public Link withType(String type) {
        return this.type == type ? this : new Link(this.rel, this.href, this.hreflang, this.media, this.title, type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    @Generated
    public Link withDeprecation(String deprecation) {
        return this.deprecation == deprecation ? this : new Link(this.rel, this.href, this.hreflang, this.media, this.title, this.type, deprecation, this.profile, this.name, this.template, this.affordances);
    }

    @Generated
    public Link withProfile(String profile) {
        return this.profile == profile ? this : new Link(this.rel, this.href, this.hreflang, this.media, this.title, this.type, this.deprecation, profile, this.name, this.template, this.affordances);
    }

    @Generated
    public Link withName(String name) {
        return this.name == name ? this : new Link(this.rel, this.href, this.hreflang, this.media, this.title, this.type, this.deprecation, this.profile, name, this.template, this.affordances);
    }
}

