/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.hal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.core.ObjectUtils;

class HalEmbeddedBuilder {
    private static final String DEFAULT_REL = "content";
    private final Map<String, List<Object>> embeddeds = new HashMap<String, List<Object>>();
    private final RelProvider provider;
    private final boolean enforceCollections;

    public HalEmbeddedBuilder(RelProvider provider, boolean enforceCollections) {
        this.provider = provider;
        this.enforceCollections = enforceCollections;
    }

    public void add(Object value) {
        List<Object> currentValue;
        Class<?> type = ObjectUtils.getResourceType(value);
        if (type == null) {
            return;
        }
        String rel = this.getDefaultedRelFor(type, true);
        if (!this.embeddeds.containsKey(rel)) {
            rel = this.getDefaultedRelFor(type, this.enforceCollections);
        }
        if ((currentValue = this.embeddeds.get(rel)) == null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(value);
            this.embeddeds.put(rel, arrayList);
        } else if (currentValue.size() == 1) {
            currentValue.add(value);
            this.embeddeds.remove(rel);
            this.embeddeds.put(this.getDefaultedRelFor(type, true), currentValue);
        } else {
            currentValue.add(value);
        }
    }

    private String getDefaultedRelFor(Class<?> type, boolean forCollection) {
        if (this.provider == null) {
            return DEFAULT_REL;
        }
        String rel = forCollection ? this.provider.getCollectionResourceRelFor(type) : this.provider.getItemResourceRelFor(type);
        return rel == null ? DEFAULT_REL : rel;
    }

    public Map<String, List<Object>> asMap() {
        return Collections.unmodifiableMap(this.embeddeds);
    }
}

