/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.core.DelegatingRelProvider;
import org.springframework.hateoas.hal.CurieProvider;
import org.springframework.hateoas.hal.HalConfiguration;
import org.springframework.hateoas.hal.Jackson2HalModule;
import org.springframework.hateoas.mvc.TypeConstrainedMappingJackson2HttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class ConverterRegisteringWebMvcConfigurer
extends WebMvcConfigurerAdapter
implements BeanFactoryAware {
    private static final String MESSAGE_SOURCE_BEAN_NAME = "linkRelationMessageSource";
    private final ObjectProvider<ObjectMapper> mapper;
    private final ObjectProvider<DelegatingRelProvider> relProvider;
    private final ObjectProvider<CurieProvider> curieProvider;
    private final ObjectProvider<HalConfiguration> halConfiguration;
    private BeanFactory beanFactory;
    private Collection<EnableHypermediaSupport.HypermediaType> hypermediaTypes;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setHypermediaTypes(Collection<EnableHypermediaSupport.HypermediaType> hyperMediaTypes) {
        this.hypermediaTypes = hyperMediaTypes;
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        for (HttpMessageConverter<?> converter : converters) {
            MappingJackson2HttpMessageConverter halConverterCandidate;
            ObjectMapper objectMapper;
            if (!(converter instanceof MappingJackson2HttpMessageConverter) || !Jackson2HalModule.isAlreadyRegisteredIn(objectMapper = (halConverterCandidate = (MappingJackson2HttpMessageConverter)converter).getObjectMapper())) continue;
            return;
        }
        ObjectMapper objectMapper = (ObjectMapper)this.mapper.getIfAvailable();
        objectMapper = objectMapper == null ? new ObjectMapper() : objectMapper;
        CurieProvider curieProvider = (CurieProvider)this.curieProvider.getIfAvailable();
        RelProvider relProvider = (RelProvider)this.relProvider.getObject();
        MessageSourceAccessor linkRelationMessageSource = (MessageSourceAccessor)this.beanFactory.getBean(MESSAGE_SOURCE_BEAN_NAME, MessageSourceAccessor.class);
        if (this.hypermediaTypes.contains((Object)EnableHypermediaSupport.HypermediaType.HAL)) {
            converters.add(0, (HttpMessageConverter<?>)this.createHalConverter(objectMapper, curieProvider, relProvider, linkRelationMessageSource));
        }
    }

    private MappingJackson2HttpMessageConverter createHalConverter(ObjectMapper objectMapper, CurieProvider curieProvider, RelProvider relProvider, MessageSourceAccessor linkRelationMessageSource) {
        HalConfiguration halConfiguration = (HalConfiguration)this.halConfiguration.getIfAvailable();
        halConfiguration = halConfiguration == null ? new HalConfiguration() : halConfiguration;
        Jackson2HalModule.HalHandlerInstantiator instantiator = new Jackson2HalModule.HalHandlerInstantiator(relProvider, curieProvider, linkRelationMessageSource, halConfiguration);
        ObjectMapper mapper = objectMapper.copy();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.registerModule((Module)new Jackson2HalModule());
        mapper.setHandlerInstantiator((HandlerInstantiator)instantiator);
        TypeConstrainedMappingJackson2HttpMessageConverter converter = new TypeConstrainedMappingJackson2HttpMessageConverter(ResourceSupport.class);
        converter.setSupportedMediaTypes(Arrays.asList(MediaTypes.HAL_JSON, MediaTypes.HAL_JSON_UTF8));
        converter.setObjectMapper(mapper);
        return converter;
    }

    public ConverterRegisteringWebMvcConfigurer(ObjectProvider<ObjectMapper> mapper, ObjectProvider<DelegatingRelProvider> relProvider, ObjectProvider<CurieProvider> curieProvider, ObjectProvider<HalConfiguration> halConfiguration) {
        this.mapper = mapper;
        this.relProvider = relProvider;
        this.curieProvider = curieProvider;
        this.halConfiguration = halConfiguration;
    }
}

