/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.hal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.hateoas.IanaRels;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.hal.CurieProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class DefaultCurieProvider
implements CurieProvider {
    private final Map<String, UriTemplate> curies;
    private final String defaultCurie;

    public DefaultCurieProvider(String name, UriTemplate uriTemplate) {
        this(Collections.singletonMap(name, uriTemplate));
    }

    public DefaultCurieProvider(Map<String, UriTemplate> curies) {
        this(curies, null);
    }

    public DefaultCurieProvider(Map<String, UriTemplate> curies, String defaultCurieName) {
        Assert.notNull(curies, (String)"Curies must not be null!");
        for (Map.Entry<String, UriTemplate> entry : curies.entrySet()) {
            String name = entry.getKey();
            UriTemplate template = entry.getValue();
            Assert.hasText((String)name, (String)"Curie name must not be null or empty!");
            Assert.notNull((Object)template, (String)"UriTemplate must not be null!");
            Assert.isTrue((template.getVariableNames().size() == 1 ? 1 : 0) != 0, (String)String.format("Expected a single template variable in the UriTemplate %s!", template.toString()));
        }
        this.defaultCurie = StringUtils.hasText((String)defaultCurieName) ? defaultCurieName : (curies.size() == 1 ? curies.keySet().iterator().next() : null);
        this.curies = Collections.unmodifiableMap(curies);
    }

    @Override
    public Collection<? extends Object> getCurieInformation(Links links) {
        ArrayList<Curie> result = new ArrayList<Curie>(this.curies.size());
        for (Map.Entry<String, UriTemplate> source : this.curies.entrySet()) {
            String name = source.getKey();
            UriTemplate template = source.getValue();
            result.add(new Curie(name, this.getCurieHref(name, template)));
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public String getNamespacedRelFrom(Link link) {
        return this.getNamespacedRelFor(link.getRel());
    }

    @Override
    public String getNamespacedRelFor(String rel) {
        boolean prefixingNeeded = this.defaultCurie != null && !IanaRels.isIanaRel(rel) && !rel.contains(":");
        return prefixingNeeded ? String.format("%s:%s", this.defaultCurie, rel) : rel;
    }

    protected String getCurieHref(String name, UriTemplate template) {
        if (template.toString().startsWith("http")) {
            return template.toString();
        }
        String applicationUri = ServletUriComponentsBuilder.fromCurrentServletMapping().build().expand(new Object[0]).toString();
        return applicationUri.concat(template.toString());
    }

    protected static class Curie
    extends Link {
        private static final long serialVersionUID = 1L;
        private final String name;

        public Curie(String name, String href) {
            super(href, "curies");
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

