/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.hateoas.Identifiable;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.util.Assert;

public abstract class IdentifiableResourceAssemblerSupport<T extends Identifiable<?>, D extends ResourceSupport>
extends ResourceAssemblerSupport<T, D> {
    private final Class<?> controllerClass;

    public IdentifiableResourceAssemblerSupport(Class<?> controllerClass, Class<D> resourceType) {
        super(controllerClass, resourceType);
        this.controllerClass = controllerClass;
    }

    protected D createResource(T entity) {
        return this.createResource(entity, new Object[0]);
    }

    protected D createResource(T entity, Object ... parameters) {
        return this.createResourceWithId(entity.getId(), entity, parameters);
    }

    @Override
    protected D createResourceWithId(Object id, T entity, Object ... parameters) {
        Assert.notNull(entity);
        Assert.notNull((Object)id);
        Object instance = this.instantiateResource(entity);
        ((ResourceSupport)instance).add(((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(this.controllerClass, this.unwrapIdentifyables(parameters)).slash(id)).withSelfRel());
        return instance;
    }

    private Object[] unwrapIdentifyables(Object[] values) {
        ArrayList<Object> result = new ArrayList<Object>(values.length);
        for (Object element : Arrays.asList(values)) {
            result.add(element instanceof Identifiable ? ((Identifiable)element).getId() : element);
        }
        return result.toArray();
    }
}

