/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minidev.json.JSONArray;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkDiscoverer;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class JsonPathLinkDiscoverer
implements LinkDiscoverer {
    private static Method compileMethod;
    private static Object emptyFilters;
    private final String pathTemplate;
    private final MediaType mediaType;

    public JsonPathLinkDiscoverer(String pathTemplate, MediaType mediaType) {
        Assert.hasText((String)pathTemplate, (String)"Path template must not be null!");
        Assert.isTrue((StringUtils.countOccurrencesOf((String)pathTemplate, (String)"%s") == 1 ? 1 : 0) != 0, (String)"Path template must contain a single placeholder!");
        this.pathTemplate = pathTemplate;
        this.mediaType = mediaType;
    }

    @Override
    public Link findLinkWithRel(String rel, String representation) {
        List<Link> links = this.findLinksWithRel(rel, representation);
        return links.isEmpty() ? null : links.get(0);
    }

    @Override
    public Link findLinkWithRel(String rel, InputStream representation) {
        List<Link> links = this.findLinksWithRel(rel, representation);
        return links.isEmpty() ? null : links.get(0);
    }

    @Override
    public List<Link> findLinksWithRel(String rel, String representation) {
        try {
            Object parseResult = this.getExpression(rel).read(representation);
            return this.createLinksFrom(parseResult, rel);
        }
        catch (InvalidPathException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public List<Link> findLinksWithRel(String rel, InputStream representation) {
        try {
            Object parseResult = this.getExpression(rel).read(representation);
            return this.createLinksFrom(parseResult, rel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JsonPath getExpression(String rel) {
        return (JsonPath)ReflectionUtils.invokeMethod((Method)compileMethod, null, (Object[])new Object[]{String.format(this.pathTemplate, rel), emptyFilters});
    }

    private List<Link> createLinksFrom(Object parseResult, String rel) {
        if (parseResult instanceof JSONArray) {
            ArrayList<Link> links = new ArrayList<Link>();
            JSONArray array = (JSONArray)parseResult;
            for (Object element : array) {
                links.add(new Link(element.toString(), rel));
            }
            return Collections.unmodifiableList(links);
        }
        return Collections.unmodifiableList(Arrays.asList(new Link(parseResult.toString(), rel)));
    }

    public boolean supports(MediaType delimiter) {
        return this.mediaType == null ? true : this.mediaType.isCompatibleWith(delimiter);
    }

    static {
        for (Method candidate : JsonPath.class.getMethods()) {
            Class<?>[] paramTypes;
            if (!candidate.getName().equals("compile") || (paramTypes = candidate.getParameterTypes()).length != 2 || !paramTypes[0].equals(String.class) || !paramTypes[1].isArray()) continue;
            compileMethod = candidate;
            emptyFilters = Array.newInstance(paramTypes[1].getComponentType(), 0);
            break;
        }
        Assert.state((compileMethod != null ? 1 : 0) != 0, (String)"Unexpected JsonPath API - no compile(String, ...) method found");
    }
}

