/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import org.springframework.hateoas.RelProvider;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;

public class DelegatingRelProvider
implements RelProvider {
    private final PluginRegistry<RelProvider, Class<?>> providers;

    public DelegatingRelProvider(PluginRegistry<RelProvider, Class<?>> providers) {
        Assert.notNull(providers, (String)"RelProviders must not be null!");
        this.providers = providers;
    }

    @Override
    public String getItemResourceRelFor(Class<?> type) {
        return ((RelProvider)this.providers.getPluginFor(type)).getItemResourceRelFor(type);
    }

    @Override
    public String getCollectionResourceRelFor(Class<?> type) {
        return ((RelProvider)this.providers.getPluginFor(type)).getCollectionResourceRelFor(type);
    }

    public boolean supports(Class<?> delimiter) {
        return this.providers.hasPluginFor(delimiter);
    }
}

