/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.LinkBuilder;
import org.springframework.hateoas.LinkBuilderFactory;
import org.springframework.hateoas.core.ControllerEntityLinks;
import org.springframework.util.Assert;

public class ControllerEntityLinksFactoryBean
extends AbstractFactoryBean<ControllerEntityLinks>
implements ApplicationContextAware {
    private Class<? extends Annotation> annotation;
    private LinkBuilderFactory<? extends LinkBuilder> linkBuilderFactory;
    private ApplicationContext context;

    public void setAnnotation(Class<? extends Annotation> annotation) {
        Assert.notNull(annotation);
        this.annotation = annotation;
    }

    public void setLinkBuilderFactory(LinkBuilderFactory<? extends LinkBuilder> linkBuilderFactory) {
        this.linkBuilderFactory = linkBuilderFactory;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    public Class<?> getObjectType() {
        return ControllerEntityLinks.class;
    }

    protected ControllerEntityLinks createInstance() throws Exception {
        HashSet controllerTypes = new HashSet();
        for (Class<?> controllerType : this.getBeanTypesWithAnnotation(this.annotation)) {
            if (AnnotationUtils.findAnnotation(controllerType, ExposesResourceFor.class) == null) continue;
            controllerTypes.add(controllerType);
        }
        return new ControllerEntityLinks(controllerTypes, this.linkBuilderFactory);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.annotation != null ? 1 : 0) != 0, (String)"Annotation type must be configured!");
        Assert.state((this.linkBuilderFactory != null ? 1 : 0) != 0, (String)"LinkBuilderFactory must be configured!");
        super.afterPropertiesSet();
    }

    private Iterable<Class<?>> getBeanTypesWithAnnotation(Class<? extends Annotation> type) {
        HashSet annotatedTypes = new HashSet();
        for (String beanName : this.context.getBeanDefinitionNames()) {
            Annotation annotation = this.context.findAnnotationOnBean(beanName, type);
            if (annotation == null) continue;
            annotatedTypes.add(this.context.getType(beanName));
        }
        return annotatedTypes;
    }
}

