/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.graphql.data.pagination.CursorStrategy;
import org.springframework.http.MediaType;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.codec.json.JacksonJsonDecoder;
import org.springframework.http.codec.json.JacksonJsonEncoder;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import tools.jackson.databind.DefaultTyping;
import tools.jackson.databind.cfg.DatatypeFeature;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;

public final class JsonKeysetCursorStrategy
implements CursorStrategy<Map<String, Object>> {
    private static final ResolvableType MAP_TYPE = ResolvableType.forClassWithGenerics(Map.class, (Class[])new Class[]{String.class, Object.class});
    private static final boolean jacksonPresent = ClassUtils.isPresent((String)"tools.jackson.databind.ObjectMapper", (ClassLoader)JsonKeysetCursorStrategy.class.getClassLoader());
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)JsonKeysetCursorStrategy.class.getClassLoader());
    private final Encoder<?> encoder;
    private final Decoder<?> decoder;
    private final DefaultDataBufferFactory bufferFactory = DefaultDataBufferFactory.sharedInstance;

    public JsonKeysetCursorStrategy() {
        this((CodecConfigurer)JsonKeysetCursorStrategy.initCodecConfigurer());
    }

    private static ServerCodecConfigurer initCodecConfigurer() {
        ServerCodecConfigurer configurer = ServerCodecConfigurer.create();
        if (jacksonPresent) {
            JacksonObjectMapperCustomizer.customize((CodecConfigurer)configurer);
        } else if (jackson2Present) {
            Jackson2ObjectMapperCustomizer.customize((CodecConfigurer)configurer);
        }
        return configurer;
    }

    public JsonKeysetCursorStrategy(CodecConfigurer codecConfigurer) {
        Assert.notNull((Object)codecConfigurer, (String)"CodecConfigurer is required");
        this.encoder = JsonKeysetCursorStrategy.findJsonEncoder(codecConfigurer);
        this.decoder = JsonKeysetCursorStrategy.findJsonDecoder(codecConfigurer);
    }

    private static Decoder<?> findJsonDecoder(CodecConfigurer configurer) {
        return configurer.getReaders().stream().filter(reader -> reader.canRead(MAP_TYPE, MediaType.APPLICATION_JSON)).map(reader -> ((DecoderHttpMessageReader)reader).getDecoder()).findFirst().orElseThrow(() -> new IllegalArgumentException("No JSON Decoder"));
    }

    private static Encoder<?> findJsonEncoder(CodecConfigurer configurer) {
        return configurer.getWriters().stream().filter(writer -> writer.canWrite(MAP_TYPE, MediaType.APPLICATION_JSON)).map(writer -> ((EncoderHttpMessageWriter)writer).getEncoder()).findFirst().orElseThrow(() -> new IllegalArgumentException("No JSON Encoder"));
    }

    @Override
    public boolean supports(Class<?> targetType) {
        return Map.class.isAssignableFrom(targetType);
    }

    @Override
    public String toCursor(Map<String, Object> keys) {
        return this.encoder.encodeValue(keys, (DataBufferFactory)DefaultDataBufferFactory.sharedInstance, MAP_TYPE, MimeTypeUtils.APPLICATION_JSON, null).toString(StandardCharsets.UTF_8);
    }

    @Override
    public Map<String, Object> fromCursor(String cursor) {
        DefaultDataBuffer buffer = this.bufferFactory.wrap(cursor.getBytes(StandardCharsets.UTF_8));
        Map<String, Object> map = (Map<String, Object>)this.decoder.decode((DataBuffer)buffer, MAP_TYPE, null, null);
        return map != null ? map : Collections.emptyMap();
    }

    private static final class JacksonObjectMapperCustomizer {
        private JacksonObjectMapperCustomizer() {
        }

        static void customize(CodecConfigurer configurer) {
            BasicPolymorphicTypeValidator validator = BasicPolymorphicTypeValidator.builder().allowIfBaseType(Map.class).allowIfSubType("java.time.").allowIfSubType(Calendar.class).allowIfSubType(Date.class).allowIfSubType(UUID.class).allowIfSubType(Number.class).allowIfSubType(Enum.class).build();
            JsonMapper mapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().activateDefaultTyping((PolymorphicTypeValidator)validator, DefaultTyping.NON_FINAL)).enable(new DatatypeFeature[]{DateTimeFeature.WRITE_DATES_AS_TIMESTAMPS})).build();
            configurer.defaultCodecs().jacksonJsonDecoder((Decoder)new JacksonJsonDecoder(mapper));
            configurer.defaultCodecs().jacksonJsonEncoder((Encoder)new JacksonJsonEncoder(mapper));
        }
    }

    private static final class Jackson2ObjectMapperCustomizer {
        private Jackson2ObjectMapperCustomizer() {
        }

        static void customize(CodecConfigurer configurer) {
            com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator validator = com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator.builder().allowIfBaseType(Map.class).allowIfSubType("java.time.").allowIfSubType(Calendar.class).allowIfSubType(Date.class).allowIfSubType(UUID.class).allowIfSubType(Number.class).allowIfSubType(Enum.class).build();
            ObjectMapper mapper = Jackson2ObjectMapperBuilder.json().build();
            mapper.activateDefaultTyping((com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator)validator, ObjectMapper.DefaultTyping.NON_FINAL);
            mapper.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            configurer.defaultCodecs().jacksonJsonDecoder((Decoder)new Jackson2JsonDecoder(mapper, new MimeType[0]));
            configurer.defaultCodecs().jacksonJsonEncoder((Encoder)new Jackson2JsonEncoder(mapper, new MimeType[0]));
        }
    }
}

