/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import graphql.ErrorClassification;
import graphql.language.SourceLocation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.ResponseError;
import org.springframework.graphql.execution.ErrorType;
import org.springframework.graphql.support.AbstractGraphQlResponse;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class ResponseMapGraphQlResponse
extends AbstractGraphQlResponse {
    private final Map<String, Object> responseMap;
    private final List<ResponseError> errors;

    ResponseMapGraphQlResponse(Map<String, Object> responseMap) {
        Assert.notNull(responseMap, (String)"'responseMap' is required");
        this.responseMap = responseMap;
        this.errors = ResponseMapGraphQlResponse.wrapErrors(responseMap);
    }

    protected ResponseMapGraphQlResponse(GraphQlResponse response) {
        Assert.notNull((Object)response, (String)"'GraphQlResponse' is required");
        this.responseMap = response.toMap();
        this.errors = response.getErrors();
    }

    private static List<ResponseError> wrapErrors(Map<String, Object> map) {
        List errors = (List)map.get("errors");
        errors = errors != null ? errors : Collections.emptyList();
        return errors.stream().map(MapResponseError::new).collect(Collectors.toList());
    }

    @Override
    public boolean isValid() {
        return this.responseMap.containsKey("data") && this.responseMap.get("data") != null;
    }

    @Override
    public List<ResponseError> getErrors() {
        return this.errors;
    }

    @Override
    public <T> @Nullable T getData() {
        return (T)this.responseMap.get("data");
    }

    @Override
    public Map<Object, Object> getExtensions() {
        return this.responseMap.getOrDefault("extensions", Collections.emptyMap());
    }

    @Override
    public Map<String, Object> toMap() {
        return this.responseMap;
    }

    public boolean equals(Object other) {
        return other instanceof ResponseMapGraphQlResponse && this.responseMap.equals(((ResponseMapGraphQlResponse)other).responseMap);
    }

    public int hashCode() {
        return this.responseMap.hashCode();
    }

    public String toString() {
        return this.responseMap.toString();
    }

    private static final class MapResponseError
    implements ResponseError {
        private final Map<String, Object> errorMap;
        private final List<SourceLocation> locations;
        private final String path;

        MapResponseError(Map<String, Object> errorMap) {
            Assert.notNull(errorMap, (String)"'errorMap' is required");
            this.errorMap = errorMap;
            this.locations = MapResponseError.initSourceLocations(errorMap);
            this.path = MapResponseError.initPath(errorMap);
        }

        private static List<SourceLocation> initSourceLocations(Map<String, Object> errorMap) {
            List locations = (List)errorMap.get("locations");
            if (locations == null) {
                return Collections.emptyList();
            }
            return locations.stream().map(m -> new SourceLocation(MapResponseError.getInt(m, "line"), MapResponseError.getInt(m, "column"), (String)m.get("sourceName"))).collect(Collectors.toList());
        }

        private static int getInt(Map<String, Object> map, String key) {
            Object object = map.get(key);
            if (object instanceof Number) {
                Number number = (Number)object;
                return number.intValue();
            }
            throw new IllegalArgumentException("Expected integer value: " + ObjectUtils.nullSafeClassName((Object)map.get(key)));
        }

        private static String initPath(Map<String, Object> errorMap) {
            List path = (List)errorMap.get("path");
            if (path == null) {
                return "";
            }
            return path.stream().reduce("", (s, o) -> s + String.valueOf(o instanceof Integer ? "[" + String.valueOf(o) + "]" : (s.isEmpty() ? o : "." + String.valueOf(o))), (s, s2) -> null);
        }

        @Override
        public @Nullable String getMessage() {
            return (String)this.errorMap.get("message");
        }

        @Override
        public List<SourceLocation> getLocations() {
            return this.locations;
        }

        @Override
        public ErrorClassification getErrorType() {
            String classification = (String)this.getExtensions().getOrDefault("classification", "");
            try {
                return graphql.ErrorType.valueOf((String)classification);
            }
            catch (IllegalArgumentException ex) {
                try {
                    return ErrorType.valueOf(classification);
                }
                catch (IllegalArgumentException ex2) {
                    return ErrorClassification.errorClassification((String)classification);
                }
            }
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public List<Object> getParsedPath() {
            return this.errorMap.getOrDefault("path", Collections.emptyList());
        }

        @Override
        public Map<String, Object> getExtensions() {
            return this.errorMap.getOrDefault("extensions", Collections.emptyMap());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResponseError other = (ResponseError)o;
            return ObjectUtils.nullSafeEquals((Object)this.getMessage(), (Object)other.getMessage()) && ObjectUtils.nullSafeEquals(this.getLocations(), other.getLocations()) && ObjectUtils.nullSafeEquals(this.getParsedPath(), other.getParsedPath()) && this.getErrorType() == other.getErrorType();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.getMessage());
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.getLocations());
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.getParsedPath());
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.getErrorType());
            return result;
        }

        public String toString() {
            return this.errorMap.toString();
        }
    }
}

