/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.support;

public enum GraphQlWebSocketMessageType {
    CONNECTION_INIT("connection_init", false),
    CONNECTION_ACK("connection_ack", false),
    PING("ping", false),
    PONG("pong", false),
    SUBSCRIBE("subscribe", true),
    NEXT("next", true),
    ERROR("error", true),
    COMPLETE("complete", false),
    NOT_SPECIFIED("", false);

    private static final GraphQlWebSocketMessageType[] VALUES;
    private final String value;
    private final boolean requiresPayload;

    private GraphQlWebSocketMessageType(String value, boolean requiresPayload) {
        this.value = value;
        this.requiresPayload = requiresPayload;
    }

    public String value() {
        return this.value;
    }

    public boolean doesNotRequirePayload() {
        return !this.requiresPayload;
    }

    public static GraphQlWebSocketMessageType fromValue(String value) {
        for (GraphQlWebSocketMessageType type : VALUES) {
            if (!type.value.equals(value)) continue;
            return type;
        }
        throw new IllegalArgumentException("No matching constant for [%s]".formatted(value));
    }

    public String toString() {
        return this.value;
    }

    static {
        VALUES = GraphQlWebSocketMessageType.values();
    }
}

