/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.graphql.client.AbstractDelegatingGraphQlClient;
import org.springframework.graphql.client.AbstractGraphQlClientSyncBuilder;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.graphql.client.HttpMessageConverterDelegate;
import org.springframework.graphql.client.HttpSyncGraphQlClient;
import org.springframework.graphql.client.HttpSyncGraphQlTransport;
import org.springframework.http.HttpHeaders;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;
import org.springframework.web.util.UriComponentsBuilder;

final class DefaultSyncHttpGraphQlClientBuilder
extends AbstractGraphQlClientSyncBuilder<DefaultSyncHttpGraphQlClientBuilder>
implements HttpSyncGraphQlClient.Builder<DefaultSyncHttpGraphQlClientBuilder> {
    private final RestClient.Builder restClientBuilder;

    DefaultSyncHttpGraphQlClientBuilder() {
        this(RestClient.builder());
    }

    DefaultSyncHttpGraphQlClientBuilder(RestClient client) {
        this(client.mutate());
    }

    DefaultSyncHttpGraphQlClientBuilder(RestClient.Builder clientBuilder) {
        this.restClientBuilder = clientBuilder;
    }

    @Override
    public DefaultSyncHttpGraphQlClientBuilder url(String url) {
        this.restClientBuilder.baseUrl(url);
        return this;
    }

    @Override
    public DefaultSyncHttpGraphQlClientBuilder url(URI url) {
        DefaultUriBuilderFactory factory = new DefaultUriBuilderFactory(UriComponentsBuilder.fromUri((URI)url));
        this.restClientBuilder.uriBuilderFactory((UriBuilderFactory)factory);
        return this;
    }

    @Override
    public DefaultSyncHttpGraphQlClientBuilder header(String name, String ... values) {
        this.restClientBuilder.defaultHeader(name, values);
        return this;
    }

    @Override
    public DefaultSyncHttpGraphQlClientBuilder headers(Consumer<HttpHeaders> headersConsumer) {
        this.restClientBuilder.defaultHeaders(headersConsumer);
        return this;
    }

    @Override
    public DefaultSyncHttpGraphQlClientBuilder messageConverters(Consumer<List<HttpMessageConverter<?>>> configurer) {
        this.restClientBuilder.messageConverters(configurer);
        return this;
    }

    @Override
    public DefaultSyncHttpGraphQlClientBuilder configureMessageConverters(Consumer<HttpMessageConverters.ClientBuilder> configurer) {
        this.restClientBuilder.configureMessageConverters(configurer);
        return this;
    }

    @Override
    public DefaultSyncHttpGraphQlClientBuilder restClient(Consumer<RestClient.Builder> configurer) {
        configurer.accept(this.restClientBuilder);
        return this;
    }

    @Override
    public HttpSyncGraphQlClient build() {
        this.restClientBuilder.messageConverters(converters -> {
            HttpMessageConverter<Object> converter = HttpMessageConverterDelegate.findJsonConverter(converters);
            this.setJsonConverter(converter);
        });
        RestClient restClient = this.restClientBuilder.build();
        HttpSyncGraphQlTransport transport = new HttpSyncGraphQlTransport(restClient);
        GraphQlClient graphQlClient = super.buildGraphQlClient(transport);
        return new DefaultHttpSyncGraphQlClient(graphQlClient, restClient, this.getBuilderInitializer());
    }

    private static class DefaultHttpSyncGraphQlClient
    extends AbstractDelegatingGraphQlClient
    implements HttpSyncGraphQlClient {
        private final RestClient restClient;
        private final Consumer<AbstractGraphQlClientSyncBuilder<?>> builderInitializer;

        DefaultHttpSyncGraphQlClient(GraphQlClient delegate, RestClient restClient, Consumer<AbstractGraphQlClientSyncBuilder<?>> builderInitializer) {
            super(delegate);
            Assert.notNull((Object)restClient, (String)"RestClient is required");
            Assert.notNull(builderInitializer, (String)"`builderInitializer` is required");
            this.restClient = restClient;
            this.builderInitializer = builderInitializer;
        }

        @Override
        public DefaultSyncHttpGraphQlClientBuilder mutate() {
            DefaultSyncHttpGraphQlClientBuilder builder = new DefaultSyncHttpGraphQlClientBuilder(this.restClient);
            this.builderInitializer.accept(builder);
            return builder;
        }
    }
}

