/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.GraphQLContext;
import graphql.GraphqlErrorBuilder;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import java.util.Locale;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;

public class DataFetchingEnvironmentMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        Class type = parameter.getParameterType();
        return type.equals(DataFetchingEnvironment.class) || type.equals(GraphQLContext.class) || type.equals(DataFetchingFieldSelectionSet.class) || type.equals(GraphqlErrorBuilder.class) || type.equals(Locale.class) || DataFetchingEnvironmentMethodArgumentResolver.isOptionalLocale(parameter);
    }

    private static boolean isOptionalLocale(MethodParameter parameter) {
        return parameter.nestedIfOptional().getNestedParameterType().equals(Locale.class);
    }

    @Override
    public @Nullable Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) {
        Class type = parameter.getParameterType();
        if (type.equals(GraphQLContext.class)) {
            return environment.getGraphQlContext();
        }
        if (type.equals(DataFetchingFieldSelectionSet.class)) {
            return environment.getSelectionSet();
        }
        if (type.equals(Locale.class)) {
            return environment.getLocale();
        }
        if (DataFetchingEnvironmentMethodArgumentResolver.isOptionalLocale(parameter)) {
            return Optional.ofNullable(environment.getLocale());
        }
        if (type.equals(DataFetchingEnvironment.class)) {
            return environment;
        }
        if (type.equals(GraphqlErrorBuilder.class)) {
            return GraphqlErrorBuilder.newError((DataFetchingEnvironment)environment);
        }
        throw new IllegalStateException("Unexpected method parameter type: " + String.valueOf(parameter));
    }
}

