/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import io.rsocket.exceptions.RejectedException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.client.GraphQlTransport;
import org.springframework.graphql.client.ResponseMapGraphQlResponse;
import org.springframework.graphql.client.SubscriptionErrorException;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class RSocketGraphQlTransport
implements GraphQlTransport {
    private static final ParameterizedTypeReference<Map<String, Object>> MAP_TYPE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private static final ResolvableType LIST_TYPE = ResolvableType.forClass(List.class);
    private final String route;
    private final RSocketRequester rsocketRequester;
    private final Decoder<?> jsonDecoder;

    RSocketGraphQlTransport(String route, RSocketRequester requester, Decoder<?> jsonDecoder) {
        Assert.notNull((Object)route, (String)"'route' is required");
        Assert.notNull((Object)requester, (String)"RSocketRequester is required");
        Assert.notNull(jsonDecoder, (String)"JSON Decoder is required");
        this.route = route;
        this.rsocketRequester = requester;
        this.jsonDecoder = jsonDecoder;
    }

    @Override
    public Mono<GraphQlResponse> execute(GraphQlRequest request) {
        return this.rsocketRequester.route(this.route, new Object[0]).data(request.toMap()).retrieveMono(MAP_TYPE).map(ResponseMapGraphQlResponse::new);
    }

    @Override
    public Flux<GraphQlResponse> executeSubscription(GraphQlRequest request) {
        return this.rsocketRequester.route(this.route, new Object[0]).data(request.toMap()).retrieveFlux(MAP_TYPE).onErrorResume(RejectedException.class, ex -> Flux.error((Throwable)this.decodeErrors(request, (RejectedException)ex))).map(ResponseMapGraphQlResponse::new);
    }

    private Exception decodeErrors(GraphQlRequest request, RejectedException ex) {
        try {
            String errorMessage = ex.getMessage() != null ? ex.getMessage() : "";
            byte[] errorData = errorMessage.getBytes(StandardCharsets.UTF_8);
            List errors = (List)this.jsonDecoder.decode((DataBuffer)DefaultDataBufferFactory.sharedInstance.wrap(errorData), LIST_TYPE, null, null);
            ResponseMapGraphQlResponse response = new ResponseMapGraphQlResponse(Collections.singletonMap("errors", errors));
            return new SubscriptionErrorException(request, response.getErrors());
        }
        catch (DecodingException ex2) {
            return ex;
        }
    }
}

